/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.utils;

import be.business.connector.core.utils.PropertyHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDumper {
    private static final Logger LOG = LoggerFactory.getLogger(MessageDumper.class);
    public static final String IN = "IN";
    public static final String OUT = "OUT";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HHmmss");
    private static MessageDumper instance;
    private static String path;
    public static final String MESSAGE_DUMPER_DIRECTORY = "messageDumper.directory";

    private MessageDumper() {
    }

    public static MessageDumper getInstance() {
        if (instance == null) {
            instance = new MessageDumper();
        }
        return instance;
    }

    public void init(PropertyHandler propertyHandler) {
        if (propertyHandler.hasProperty(MESSAGE_DUMPER_DIRECTORY)) {
            path = propertyHandler.getProperty(MESSAGE_DUMPER_DIRECTORY);
        }
    }

    public boolean isDumpEnabled() {
        File dir;
        return path != null && !"".equals(path) && (dir = new File(path)).exists() && dir.isDirectory();
    }

    public void dump(ByteArrayOutputStream bos, String name, String way) {
        try {
            File dir;
            if (path != null && !"".equals(path) && (dir = new File(path)).exists() && dir.isDirectory() && StringUtils.isNotBlank((CharSequence)name)) {
                FileOutputStream fos = new FileOutputStream(this.generateFileName(name, way));
                bos.writeTo(fos);
                ((OutputStream)fos).close();
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("dump error", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("dump error", (Throwable)e);
        }
    }

    public void dump(byte[] data, String name, String way) {
        try {
            int read;
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] temp = new byte[1024];
            while ((read = bis.read(temp)) > 0) {
                buffer.write(temp, 0, read);
            }
            this.dump(buffer, name, way);
            bis.close();
            buffer.close();
        }
        catch (FileNotFoundException e) {
            LOG.error("dump error", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("dump error", (Throwable)e);
        }
    }

    private File generateFileName(String name, String way) {
        String direction = IN.equalsIgnoreCase(way) ? "-IN-" : "-OUT-";
        return new File(path, name + direction + new Date().getTime() + ".xml");
    }

    public static String getOperationName(SOAPMessageContext context) {
        try {
            return context.getMessage().getSOAPBody().getFirstChild().getLocalName();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to get wsdl operation name", e);
        }
    }

    static {
        path = "";
    }
}

