/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.utils;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.exceptions.XMLGenerationException;
import be.business.connector.core.exceptions.XMLValidationException;
import be.business.connector.core.services.GenericWebserviceCaller;
import be.business.connector.core.utils.ClasspathLSResourceResolver;
import be.business.connector.core.utils.EncryptionUtils;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.IOUtils;
import be.business.connector.core.utils.MessageDumper;
import be.business.connector.core.utils.PropertyHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Key;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class MarshallerHelper<X, Y> {
    private static boolean allowXSDValidation = true;
    private Logger logger = LoggerFactory.getLogger(MarshallerHelper.class);
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;

    public MarshallerHelper(Class<X> unmarshallClass, Class<Y> marshallClass) {
        try {
            this.unmarshaller = JAXBContext.newInstance((Class[])new Class[]{unmarshallClass}).createUnmarshaller();
            this.marshaller = JAXBContext.newInstance((Class[])new Class[]{marshallClass}).createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("JAXBException " + (Object)((Object)e));
        }
    }

    public static void withoutXSDValidation(Runnable task) {
        try {
            allowXSDValidation = false;
            task.run();
        }
        finally {
            allowXSDValidation = true;
        }
    }

    public byte[] toXMLByteArray(Y data) {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.marshaller.marshal(data, (OutputStream)bos);
            MessageDumper.getInstance().dump(bos, data.getClass().getSimpleName(), "OUT");
            this.validate(bos.toByteArray());
            if (this.payloadLoggingEnabled()) {
                this.logger.debug(this.prettyPrint(bos.toByteArray()));
            }
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JAXBException e) {
                throw new IllegalArgumentException("JAXBException " + (Object)((Object)e));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("IOException " + e);
            }
        }
        bos.close();
        return byArray;
    }

    private void validate(byte[] xmlBytes) {
        if (this.schemaValidationEnabled() && allowXSDValidation) {
            this.logger.debug("Validating XML against Schema...");
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            HashMap<String, String> schemaMapping = new HashMap<String, String>();
            schemaMapping.put("http://www.w3.org/2000/09/xmldsig#", "/META-INF/external/XSD/xmldsig-core-schema.xsd");
            schemaMapping.put("http:/services.recipe.be/core", "/META-INF/recipe-central-system-unsealed/XSD/recipe-core.xsd");
            schemaFactory.setResourceResolver(new ClasspathLSResourceResolver(schemaMapping));
            try (InputStream prescriberSchema = GenericWebserviceCaller.class.getResourceAsStream("/META-INF/recipe-central-system-unsealed/XSD/UnsealedPrescriberServicesV4_schema1.xsd");
                 InputStream patientSchema = GenericWebserviceCaller.class.getResourceAsStream("/META-INF/recipe-central-system-unsealed/XSD/UnsealedPatientServicesV4_schema1.xsd");
                 InputStream executorSchema = GenericWebserviceCaller.class.getResourceAsStream("/META-INF/recipe-central-system-unsealed/XSD/UnsealedExecutorServicesV4_schema1.xsd");){
                Schema schema = schemaFactory.newSchema(new Source[]{new StreamSource(prescriberSchema), new StreamSource(patientSchema), new StreamSource(executorSchema)});
                Validator validator = schema.newValidator();
                validator.validate(new StreamSource(new ByteArrayInputStream(xmlBytes)));
            }
            catch (IOException | SAXException e) {
                this.logger.warn("XML Schema validation failed!", (Throwable)e);
                throw new XMLValidationException("Failed to validate XML!" + System.lineSeparator() + this.prettyPrint(xmlBytes), e);
            }
        }
    }

    private String prettyPrint(byte[] xmlBytes) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new StreamSource(new ByteArrayInputStream(xmlBytes)), new StreamResult(writer));
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new XMLValidationException("Failed to pretty print XML!", e);
        }
    }

    private boolean schemaValidationEnabled() {
        String status = PropertyHandler.getInstance().getProperty("connector.xml.schema.validation", "disabled");
        this.logger.debug("XML schema validation " + status + "!");
        return status.equals("enabled");
    }

    private boolean payloadLoggingEnabled() {
        String status = PropertyHandler.getInstance().getProperty("connector.xml.schema.validation.payload.logging", "disabled");
        return status.equals("enabled");
    }

    public X toObject(byte[] data) {
        if (this.responseSchemaValidationEnabled()) {
            this.validate(data);
        }
        if (this.payloadLoggingEnabled()) {
            this.logger.debug(this.prettyPrint(data));
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            Object result = this.unmarshaller.unmarshal((InputStream)bis);
            bis.close();
            MessageDumper.getInstance().dump(data, result.getClass().getSimpleName(), "IN");
            return (X)result;
        }
        catch (IOException | JAXBException e) {
            throw new XMLGenerationException((Exception)e);
        }
    }

    public X toObject(InputStream inputStream) {
        byte[] data = IOUtils.getBytes(inputStream);
        return this.toObject(data);
    }

    public String marsh(Y data) throws JAXBException {
        StringWriter stringWriter = new StringWriter();
        this.marshaller.marshal(data, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public X unmarsh(String data) throws JAXBException {
        return (X)this.unmarshaller.unmarshal((Reader)new StringReader(data));
    }

    public X unmarsh(byte[] data) throws IntegrationModuleException {
        try {
            return (X)this.unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(data));
        }
        catch (JAXBException e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.single.message.validation"), e);
        }
    }

    public X unmarshSystemConfiguration(byte[] data) throws IntegrationModuleException {
        try {
            return (X)this.unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(data));
        }
        catch (JAXBException e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.systemconfiguration.validation"), e);
        }
    }

    public X unmarshProductFilter(byte[] data) throws IntegrationModuleException {
        try {
            return (X)this.unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(data));
        }
        catch (JAXBException e) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.productFilter.validation"), e);
        }
    }

    public X unsealWithSymmKey(byte[] data, Key symmKey) {
        data = EncryptionUtils.unsealWithSymmKey(symmKey, data);
        return this.toObject(data);
    }

    private boolean responseSchemaValidationEnabled() {
        String status = PropertyHandler.getInstance().getProperty("connector.xml.schema.response.validation", "disabled");
        this.logger.debug("XML response schema validation " + status + "!");
        return status.equals("enabled");
    }

    public byte[] unsealWithKey(byte[] data, Key symmKey) {
        return EncryptionUtils.unsealWithSymmKey(symmKey, data);
    }

    public void writePrescriptionToFile(byte[] unsealByteWithSymmKeyDecodeAndDecompress, String archivingPath) throws IOException, IntegrationModuleException {
        if (StringUtils.isBlank((CharSequence)archivingPath)) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.archiving.path.missing"));
        }
        FileUtils.writeByteArrayToFile((File)new File(archivingPath), (byte[])unsealByteWithSymmKeyDecodeAndDecompress);
    }
}

