/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.utils;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.I18nHelper;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateParser {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateParser.class);
    private static final String ORGANIZATION_UNIT_NAME_ATTRIBUTE_TYPE = "OU";
    private static final String COMMON_NAME_ATTRIBUTE_TYPE = "CN";
    private static final String REGXP_VALIDATION = "([A-Z(-|_)]+=[0-9]+)";
    private static final String FEDERAL_GOVERMENT = "Federal Government";
    private static final String EHEALTH_PLATFORM = "eHealth-platform Belgium";
    private static final String ESCAPE_CHAR = "=";
    private static final String X500_KEY_VALUE_SEPARATOR = "=";
    private static final String X500_FIELD_SEPARATOR = ",";
    private static final String X500_START_STRING_DELIMITER = "=\"";
    private static final String X500_END_STRING_DELIMITER = "\", ";
    private static final String X500_ESCAPE_CHARACTER = "\\";
    private static final String SAN_ESCAPE_CHAR = "&bksp;";
    private static final String SAN_ESCAPED_QUOTE = "&bkqt;";
    private String type = "";
    private String value = "";
    private String application = "";

    public CertificateParser(X509Certificate cert) throws IntegrationModuleException {
        this(cert.getSubjectX500Principal().getName("RFC1779"));
    }

    public CertificateParser(String subject) throws IntegrationModuleException {
        LOG.info("CertificateParser subject: " + subject);
        HashMap<String, ArrayList<String>> subjects = this.splitCertificateString(subject);
        String commonName = subjects.get(COMMON_NAME_ATTRIBUTE_TYPE).get(0);
        LOG.debug("Certificate CN:" + commonName);
        ArrayList<String> ouList = subjects.get(ORGANIZATION_UNIT_NAME_ATTRIBUTE_TYPE);
        LOG.debug("Certificate OUList loaded");
        if (ouList == null || ouList.size() == 0) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.corrupt.system.certificate"));
        }
        for (String ou : ouList) {
            LOG.debug("OU:" + ou);
            if (Pattern.matches(REGXP_VALIDATION, ou)) {
                String[] splittedOU = ou.split("=");
                this.type = splittedOU[0];
                this.value = splittedOU[1];
                LOG.debug("Certificat type: " + this.type + " &  value: " + this.value);
                continue;
            }
            if (ouList.size() < 4 || ou.equals(FEDERAL_GOVERMENT) || ou.equals(EHEALTH_PLATFORM) || commonName.indexOf(ou) < 0) continue;
            LOG.debug("Certificat application id: " + this.application);
            this.application = ou;
        }
    }

    private HashMap<String, ArrayList<String>> splitCertificateString(String x500PrincipalName) {
        HashMap<String, ArrayList<String>> items = new HashMap<String, ArrayList<String>>();
        int indexOfEscapeCharacter = x500PrincipalName.indexOf(X500_ESCAPE_CHARACTER);
        String workString = null;
        if (indexOfEscapeCharacter > 0) {
            workString = x500PrincipalName.replace("\\\\", SAN_ESCAPE_CHAR);
            workString = workString.replace("\\\"", SAN_ESCAPED_QUOTE);
        } else {
            workString = x500PrincipalName;
        }
        LOG.debug("The certificatestring in splitCertificateString 1: " + workString);
        int indexOfStringDelimiter = x500PrincipalName.indexOf(X500_START_STRING_DELIMITER);
        if (indexOfStringDelimiter == -1) {
            String[] x500Fields = workString.split(X500_FIELD_SEPARATOR);
            for (int i = 0; i < x500Fields.length; ++i) {
                String x500Field = x500Fields[i];
                if (StringUtils.isNotEmpty((String)x500Field) && x500Field.split("=").length == 3) {
                    LOG.debug("x500Field has several = in his value: " + x500Field + " and we check the next field for the application id");
                    if (i + 1 < x500Fields.length) {
                        String x500Field2;
                        if (StringUtils.isNotEmpty((String)(x500Field2 = x500Fields[++i])) && x500Field2.split("=").length > 1) {
                            LOG.debug("x500Field has several = in his value: " + x500Field + " and we didn't find the application id");
                            this.addX500Field(x500Field, items);
                            this.addX500Field(x500Field2, items);
                            continue;
                        }
                        LOG.debug("x500Field has several = in his value: " + x500Field + " and we found the application id: " + x500Field2);
                        this.addX500Field(x500Field + ", " + x500Field2, items);
                        continue;
                    }
                    this.addX500Field(x500Field, items);
                    continue;
                }
                this.addX500Field(x500Field, items);
            }
        } else {
            LOG.debug("The workstring had seceral quotes. The method will be used: splitStringWithquotes");
            String[] x500Fields = this.splitStringWithquotes(workString).toArray(new String[0]);
            for (int i = 0; i < x500Fields.length; ++i) {
                this.addX500Field(x500Fields[i], items);
            }
        }
        return items;
    }

    private List<String> splitStringWithquotes(String x500PrincipalName) {
        boolean notFinished = true;
        ArrayList<String> tempList = new ArrayList<String>();
        String workString = x500PrincipalName;
        int indexOfStringDelimiter = workString.indexOf(X500_START_STRING_DELIMITER);
        int indexOfFieldSeparator = workString.indexOf(X500_FIELD_SEPARATOR);
        while (notFinished) {
            if (indexOfStringDelimiter == -1 || indexOfFieldSeparator < indexOfStringDelimiter) {
                LOG.debug("splitStringWithquotes: if statement one");
                String[] tempStringTable = workString.split(X500_FIELD_SEPARATOR, 2);
                tempList.add(tempStringTable[0].trim());
                workString = tempStringTable[1].trim();
            } else if (workString.indexOf(X500_END_STRING_DELIMITER) != -1) {
                LOG.debug("splitStringWithquotes: if statement two");
                String tempString = workString.substring(0, workString.indexOf(X500_END_STRING_DELIMITER) + 1);
                tempList.add(tempString);
                workString = workString.substring(workString.indexOf(X500_END_STRING_DELIMITER) + 3);
            } else if (workString.indexOf(X500_FIELD_SEPARATOR) != -1 && workString.indexOf("=") != -1) {
                LOG.debug("splitStringWithquotes: if statement three");
                tempList.add(workString);
                workString = workString.substring(workString.length());
            }
            indexOfStringDelimiter = workString.indexOf(X500_START_STRING_DELIMITER);
            indexOfFieldSeparator = workString.indexOf(X500_FIELD_SEPARATOR);
            if (indexOfFieldSeparator != -1) continue;
            notFinished = false;
            if (!StringUtils.isNotEmpty((String)workString)) continue;
            LOG.debug("splitStringWithquotes: last field added for pharmacist");
            tempList.add(workString);
        }
        return tempList;
    }

    private void addX500Field(String x500Field, HashMap<String, ArrayList<String>> x500Fields) {
        String[] parts = x500Field.split("=", 2);
        if (parts.length == 2) {
            String key = parts[0].trim();
            String value = parts[1].trim();
            value = value.replace(SAN_ESCAPE_CHAR, "\\\\");
            if ((value = value.replace(SAN_ESCAPED_QUOTE, "\\\"")).charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                value = value.substring(1, value.length() - 1);
            }
            LOG.info("X500Field: key [" + key + "], value [" + value + "]");
            ArrayList<String> list = x500Fields.get(key);
            if (list == null) {
                list = new ArrayList();
                x500Fields.put(key, list);
            }
            list.add(value);
        } else {
            LOG.info("X500Field [" + x500Field + "] has invalid structure. Ignoring ...");
        }
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getApplication() {
        return this.application;
    }
}

