/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.exceptions;

import be.recipe.common.exceptions.RecipeException;
import be.recipe.common.exceptions.RecipeExceptionDetails;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationModuleRuntimeException
extends RuntimeException {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationModuleRuntimeException.class);
    private static final long serialVersionUID = 1L;

    public IntegrationModuleRuntimeException(String message, Throwable cause) {
        super(message, cause);
        LOG.error(message, (Throwable)this);
    }

    public IntegrationModuleRuntimeException(String message) {
        super(message);
        LOG.error(message, (Throwable)this);
    }

    public IntegrationModuleRuntimeException(Throwable cause) {
        super(cause);
        LOG.error("IntegrationModuleException", cause);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        RecipeExceptionDetails.ErrorMap list;
        RecipeExceptionDetails e;
        String locale = IntegrationModuleRuntimeException.getUserLocale();
        Throwable cause = this.getCause();
        if (cause instanceof RecipeException) {
            e = ((RecipeException)cause).getFaultInfo();
            list = e.getErrorMap();
            for (RecipeExceptionDetails.ErrorMap.Entry entry : list.getEntries()) {
                if (!entry.getKey().startsWith(locale)) continue;
                return entry.getValue().getMessage() + "\n" + entry.getValue().getResolution();
            }
        }
        if (cause instanceof RecipeException) {
            e = ((RecipeException)cause).getFaultInfo();
            list = e.getErrorMap();
            for (RecipeExceptionDetails.ErrorMap.Entry entry : list.getEntries()) {
                if (!entry.getKey().startsWith(locale)) continue;
                return entry.getValue().getMessage() + "\n" + entry.getValue().getResolution();
            }
        }
        return super.getMessage();
    }

    public static String getUserLocale() {
        String locale = Locale.getDefault().getLanguage();
        if (!(locale.equalsIgnoreCase("nl") || locale.equalsIgnoreCase("fr") || locale.equalsIgnoreCase("en"))) {
            Locale.setDefault(Locale.ENGLISH);
            locale = Locale.ENGLISH.getLanguage();
        }
        return locale;
    }
}

