/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.ehealth.services;

import be.business.connector.core.ehealth.services.KgssService;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.PersistentCache;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.UnsealConnectorException;
import be.ehealth.technicalconnector.service.ServiceFactory;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionItem;
import be.fgov.ehealth.etee.crypto.status.NotificationError;
import be.fgov.ehealth.etee.crypto.status.NotificationWarning;
import be.fgov.ehealth.etee.kgss._1_0.protocol.CredentialType;
import be.fgov.ehealth.etee.kgss._1_0.protocol.GetKeyRequestContent;
import be.fgov.ehealth.etee.kgss._1_0.protocol.GetKeyResponseContent;
import be.fgov.ehealth.etee.kgss._1_0.protocol.GetNewKeyRequestContent;
import be.fgov.ehealth.etee.kgss._1_0.protocol.GetNewKeyResponseContent;
import java.util.Arrays;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.codec.binary.Base64;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KgssServiceImpl
implements KgssService {
    private static final Logger LOG = LoggerFactory.getLogger(KgssServiceImpl.class);
    private static KgssService kgssService;
    private final PersistentCache kgssKeyCache = PersistentCache.getInstance();

    private KgssServiceImpl() throws IntegrationModuleException {
    }

    public static KgssService getInstance() throws IntegrationModuleException {
        if (kgssService == null) {
            kgssService = new KgssServiceImpl();
        }
        return kgssService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Profiled(logFailuresSeparately=true, tag="0.KgssServiceImpl#retrieveKeyFromKgss", logger="org.perf4j.TimingLogger_Common")
    public KeyResult retrieveKeyFromKgss(byte[] keyId, byte[] myEtk, byte[] kgssEtk) throws IntegrationModuleException {
        LOG.debug("KeyIdentifier : " + Arrays.toString(keyId));
        if (this.kgssKeyCache.containsKey(new String(keyId))) {
            LOG.debug("KGSSKeyCache item found");
            byte[] key = this.kgssKeyCache.get(new String(keyId));
            return new KeyResult((SecretKey)new SecretKeySpec(key, "AES"), new String(keyId));
        }
        GetKeyRequestContent getKeyRequestContent = new GetKeyRequestContent();
        SecretKey key = null;
        if (myEtk != null) {
            getKeyRequestContent.setETK(myEtk);
        } else {
            try {
                KeyGenerator keyGen;
                KeyGenerator keyGenerator = keyGen = KeyGenerator.getInstance("AES");
                synchronized (keyGenerator) {
                    key = keyGen.generateKey();
                }
            }
            catch (Exception e) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.technical"), e);
            }
            getKeyRequestContent.setKeyEncryptionKey(key.getEncoded());
        }
        getKeyRequestContent.setKeyIdentifier(Base64.decodeBase64((byte[])keyId));
        try {
            be.ehealth.technicalconnector.service.kgss.KgssService kgss = ServiceFactory.getKgssService();
            SessionItem sessionItem = Session.getInstance().getSession();
            GetKeyResponseContent getKeyResponseContent = kgss.getKey(getKeyRequestContent, sessionItem.getHolderOfKeyCredential(), sessionItem.getEncryptionCredential(), sessionItem.getSAMLToken().getAssertion(), sessionItem.getEncryptionPrivateKeys(), kgssEtk);
            KeyResult keyResultToReturn = new KeyResult((SecretKey)new SecretKeySpec(getKeyResponseContent.getKey(), "AES"), new String(keyId));
            this.kgssKeyCache.put(new String(keyId), getKeyResponseContent.getKey());
            return keyResultToReturn;
        }
        catch (SOAPFaultException se) {
            if (se.getFault() != null && se.getFault().getFaultCode() != null && se.getFault().getFaultCode().contains("InvalidSecurity")) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.kgss.getKey"), se);
            }
            throw new IntegrationModuleException(I18nHelper.getLabel("error.kgss.getKey.other"), se);
        }
        catch (WebServiceException cte) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.kgss"), cte);
        }
        catch (TechnicalConnectorException e) {
            LOG.error("Error retrieving key", (Throwable)e);
            throw new IntegrationModuleException(I18nHelper.getLabel("technical.connector.error.retrieve.key"), e);
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.KgssServiceImpl#retrieveNewKey", logger="org.perf4j.TimingLogger_Common")
    public KeyResult retrieveNewKey(byte[] etkKgss, List<String> credentialTypes, String prescriberId, String executorId, String patientId, byte[] myEtk) throws IntegrationModuleException {
        GetNewKeyRequestContent req = new GetNewKeyRequestContent();
        req.setETK(myEtk);
        List allowedReaders = req.getAllowedReaders();
        for (String credentialTypeStr : credentialTypes) {
            String[] atrs = credentialTypeStr.split(",");
            if (atrs.length != 3 && atrs.length != 2) {
                throw new IntegrationModuleException("Invalid credentialType: " + credentialTypeStr);
            }
            String value = "";
            if (atrs.length == 3) {
                value = atrs[2];
                value = value.replaceAll("%PRESCRIBER_ID%", prescriberId);
                value = value.replaceAll("%EXECUTOR_ID%", executorId);
                value = value.replaceAll("%PATIENT_ID%", patientId);
            }
            CredentialType ct = new CredentialType();
            ct.setNamespace(atrs[0]);
            ct.setName(atrs[1]);
            ct.getValues().add(value);
            allowedReaders.add(ct);
        }
        try {
            be.ehealth.technicalconnector.service.kgss.KgssService kgss = ServiceFactory.getKgssService();
            SessionItem sessionItem = Session.getInstance().getSession();
            GetNewKeyResponseContent getNewKeyResponseContent = kgss.getNewKey(req, sessionItem.getEncryptionCredential(), sessionItem.getEncryptionPrivateKeys(), etkKgss);
            byte[] keyResponse = getNewKeyResponseContent.getNewKey();
            byte[] keyId = getNewKeyResponseContent.getNewKeyIdentifier();
            KeyResult keyResultToReturn = new KeyResult((SecretKey)new SecretKeySpec(keyResponse, "AES"), new String(Base64.encodeBase64((byte[])keyId)));
            this.kgssKeyCache.put(keyResultToReturn.getKeyId(), keyResponse);
            return keyResultToReturn;
        }
        catch (TechnicalConnectorException e) {
            LOG.error("Error retrieving new key", (Throwable)e);
            if (e instanceof UnsealConnectorException && ((UnsealConnectorException)e).getUnsealResult() != null) {
                List decryptionFailure = ((UnsealConnectorException)e).getUnsealResult().getErrors();
                for (NotificationError error : decryptionFailure) {
                    LOG.error("NotificationError: " + error.toString());
                }
                List warnings = ((UnsealConnectorException)e).getUnsealResult().getWarnings();
                for (NotificationWarning warning : warnings) {
                    LOG.error("NotificationWarning: " + warning.toString());
                }
            }
            throw new IntegrationModuleException(I18nHelper.getLabel("technical.connector.error.retrieve.new.key"), e);
        }
    }

    @Override
    public void clear() {
        this.kgssKeyCache.clear();
    }
}

