/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.domain;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum KgssIdentifierType {
    CBE("CBE"),
    SSIN("SSIN"),
    NIHII("NIHII"),
    NIHII_PHARMACY("NIHII-PHARMACY"),
    NIHII_HOSPITAL("NIHII-HOSPITAL");

    private String name;
    private static Map<String, KgssIdentifierType> lookup;

    private KgssIdentifierType(String name) {
        this.name = name;
    }

    public static KgssIdentifierType lookup(String name) {
        if (lookup.containsKey(name)) {
            return lookup.get(name);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    static {
        lookup = new HashMap<String, KgssIdentifierType>();
        for (KgssIdentifierType type : EnumSet.allOf(KgssIdentifierType.class)) {
            lookup.put(type.getName(), type);
        }
    }
}

