/*
 * (C) 2021 Recip-e. All rights reserved.
 */
package be.business.connector.recipe.utils.prescribercreatebulkprescriptions;

import be.business.connector.recipe.prescriber.dto.CreatePrescriptionDTO;
import org.perf4j.aop.Profiled;

public class CreateEncryptedPrescriptionsJavaThread extends Thread implements CreateEncryptedPrescriptionsThread {

	private final CreateEncryptedPrescriptionsTask task;

	public CreateEncryptedPrescriptionsJavaThread(final CreateEncryptedPrescriptionsTask task) {
		this.task = task;
	}

	@Override
	@Profiled(logFailuresSeparately = true, tag = "0.PrescriptionDecryptorThread#decryption", logger = "org.perf4j.TimingLogger_Common")
	public void run() {
		task.run();
	}

	@Override
	public void execute() {
		super.start();
	}

	@Override
	public CreatePrescriptionDTO getData() {
		return task.getData();
	}

}