/*
 * (C) 2021 Recip-e. All rights reserved.
 */
package be.business.connector.recipe.utils.executorlistopenprescriptions;

import org.perf4j.aop.Profiled;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.recipe.services.executor.GetOpenPrescriptionForExecutor;

public class DecryptPrescriptionJavaThread extends Thread implements DecryptPrescriptionThread {

	private final DecryptPrescriptionTask task;

	public DecryptPrescriptionJavaThread(final DecryptPrescriptionTask task) {
		this.task = task;
	}

	@Override
	@Profiled(logFailuresSeparately = true, tag = "0.PrescriptionDecryptorThread#decryption", logger = "org.perf4j.TimingLogger_Common")
	public void run() {
		task.run();
	}

	@Override
	public void execute() {
		super.start();
	}

	@Override
	public GetOpenPrescriptionForExecutor getPrescription() {
		return task.getPrescription();
	}


	@Override
	public IntegrationModuleException getError() {
		return task.getError();
	}
}