package be.business.connector.recipe.prescriber;

import be.business.connector.recipe.prescriber.domain.ListPrescriptionHistoryParam;
import be.business.connector.recipe.prescriber.domain.ListPrescriptionHistoryResult;
import be.business.connector.recipe.prescriber.dto.CreatePrescriptionDTO;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.recipe.api.Prescription;
import be.recipe.api.prescriber.GetPrescription;
import be.recipe.api.prescriber.ListPrescriptions;
import be.recipe.api.prescriber.PutVisionOtherPrescribers;
import be.recipe.api.prescriber.VisionOtherPrescribers;
import be.recipe.services.prescriber.*;
import java.util.List;

/** The Interface PrescriberIntegrationModuleV4. */
public interface PrescriberIntegrationModuleV4
    extends ListPrescriptions.Command<ListPrescriptions, ListPrescriptions.Response.PlainText>,
        PutVisionOtherPrescribers.Command<PutVisionOtherPrescribers>,
        GetPrescription.Command<GetPrescription, Prescription.PlainText> {

  /**
   * Creates the prescription.
   *
   * @param feedbackRequested the feedback requested
   * @param patientId the patient id
   * @param prescription the prescription
   * @param prescriptionType the prescription type
   * @param visibility the visibility
   * @param expirationDate the expiration date
   * @return the rid @ the integration module exception
   */
  String createPrescription(
      boolean feedbackRequested,
      String patientId,
      byte[] prescription,
      String prescriptionType,
      String visibility,
      String expirationDate);

  String createPrescription(
      boolean feedbackRequested,
      String patientId,
      byte[] prescription,
      String prescriptionType,
      String visibility,
      VisionOtherPrescribers visionOtherPrescribers,
      String expirationDate);

  /**
   * Gets the prescription status.
   *
   * @param data the {@link GetPrescriptionStatusParam}
   * @return the {@link GetPrescriptionStatusResult} @ the integration module exception
   */
  GetPrescriptionStatusResult getData(GetPrescriptionStatusParam data);

  /**
   * Lists the prescription history.
   *
   * @param request the {@link ListPrescriptionHistoryParam}
   * @return the {@link ListPrescriptionHistoryResult} @ the integration module exception
   */
  ListRidsHistoryResult getData(ListRidsHistoryParam request);

  /**
   * Put the vision.
   *
   * @param request the {@link PutVisionParam}
   * @return the {@link PutVisionResult} @ the integration module exception
   */
  PutVisionResult putData(PutVisionParam request);

  /**
   * Gets the open prescription list.
   *
   * @param data the {@link ListOpenRidsParam}
   * @return the {@link ListOpenRidsResult} @ the integration module exception
   */
  ListOpenRidsResult getData(ListOpenRidsParam data);

  /**
   * Gets the validation properties.
   *
   * @param data the {@link ValidationPropertiesParam}
   * @return the {@link ValidationPropertiesResult} @ the integration module exception
   */
  ValidationPropertiesResult getData(ValidationPropertiesParam data);

  /**
   * @param feedbackRequested the feedbackRequested
   * @param patientId the patientId
   * @param prescription the prescription
   * @param prescriptionType the prescriptionType
   * @return the prescription
   */
  String createPrescription(
      boolean feedbackRequested, String patientId, byte[] prescription, String prescriptionType);

  /**
   * @param patientId the patient id
   */
  void prepareCreatePrescription(String patientId);

  /**
   * @param rid the rid
   * @return the prescription
   */
  GetPrescriptionForPrescriberResult getPrescription(String rid);

  /**
   * @param rid the rid
   * @param reason the reason
   */
  void revokePrescription(String rid, String reason);

  /**
   * @param notificationText the notificationText
   * @param patientId the patientId
   * @param executorId the executorId
   */
  void sendNotification(byte[] notificationText, String patientId, String executorId, String hospitalId);
  void sendNotification(byte[] notificationText, String patientId, String executorId);

  /**
   * @param rid the rid
   * @param feedbackAllowed the feedbackAllowed
   */
  void updateFeedbackFlag(String rid, boolean feedbackAllowed);

  /**
   * @param readFlag the readFlag
   * @return the feedback items
   */
  List<ListFeedbackItem> listFeedback(boolean readFlag);

  /**
   * @param createPrescriptionDTOs the create prescripion dto's
   * @return the create prescription dto's
   */
  List<CreatePrescriptionDTO> createPrescriptions(
      List<CreatePrescriptionDTO> createPrescriptionDTOs) throws TechnicalConnectorException;
}
