package be.business.connector.recipe.patient;

import be.recipe.services.executor.ListOpenPrescriptionsParam;
import be.recipe.services.executor.ListOpenPrescriptionsResult;
import be.recipe.services.patient.CreateReservationParam;
import be.recipe.services.patient.CreateReservationResult;
import be.recipe.services.patient.GetPrescriptionStatusParam;
import be.recipe.services.patient.GetPrescriptionStatusResult;
import be.recipe.services.patient.GetVisionParam;
import be.recipe.services.patient.GetVisionResult;
import be.recipe.services.patient.ListOpenRidsParam;
import be.recipe.services.patient.ListOpenRidsResult;
import be.recipe.services.patient.ListPatientPrescriptionsParam;
import be.recipe.services.patient.ListPatientPrescriptionsResult;
import be.recipe.services.patient.PutVisionParam;
import be.recipe.services.patient.PutVisionResult;

/**
 * The Interface PatientIntegrationModuleDevV4.
 * 
 * @author <a href="mailto:bruno.casneuf@healthconnect.be">Bruno Casneuf</a>
 */
public interface PatientIntegrationModuleDevV4 extends PatientIntegrationModuleV4 {

	/**
	 * Gets the vision.
	 *
	 * @param request
	 *            the {@link GetVisionParam}
	 * @return the {@link GetVisionResult} @ the integration module exception
	 */
	@Override
	GetVisionResult getData(GetVisionParam request);

	/**
	 * Put the vision .
	 *
	 * @param request
	 *            the {@link PutVisionParam}
	 * @return the {@link PutVisionResult} @ the integration module exception
	 */
	@Override
	PutVisionResult putData(PutVisionParam request);

	/**
	 * Put the reservation data.
	 *
	 * @param data
	 *            the {@link CreateReservationParam}
	 * @return the {@link CreateReservationResult} @ the integration module exception
	 */
	@Override
	CreateReservationResult putData(CreateReservationParam data);

	/**
	 * Gets the prescription status.
	 *
	 * @param data
	 *            the {@link GetPrescriptionStatusParam}
	 * @return the {@link GetPrescriptionStatusResult} @ the integration module exception
	 */
	@Override
	GetPrescriptionStatusResult getData(GetPrescriptionStatusParam data);

	/**
	 * Gets the open prescription list.
	 *
	 * @param request
	 *            the {@link ListOpenPrescriptionsParam}
	 * @return the {@link ListOpenPrescriptionsResult} @ the integration module exception
	 */
	@Override
	ListOpenRidsResult getData(ListOpenRidsParam request);


	/**
	 * Lists the open prescriptions
	 */
	@Override
	ListPatientPrescriptionsResult listOpenPrescriptions(ListPatientPrescriptionsParam listPatientPrescriptionsParam);
}
