package be.business.connector.recipe;

import be.business.connector.recipe.executor.RecipeExecutorClient;
import be.business.connector.recipe.patient.RecipePatientClient;
import be.business.connector.recipe.prescriber.RecipePrescriberClient;
import be.recipe.api.GetPrescriptionStatusResponse;
import be.recipe.api.Prescription;
import be.recipe.api.PrescriptionService;
import be.recipe.api.executor.*;
import be.recipe.api.patient.GetExecutorProfile;
import be.recipe.api.patient.PutVisionExecutors;
import be.recipe.api.prescriber.CreatePrescription;
import be.recipe.api.prescriber.PutVisionOtherPrescribers;
import be.recipe.api.prescriber.RevokePrescription;

public class RoutingPrescriptionService implements PrescriptionService.Simplified {
  private final RecipePrescriberClient prescriberClient;
  private final RecipeExecutorClient executorClient;
  private final RecipePatientClient patientClient;

  public RoutingPrescriptionService(
      RecipePrescriberClient prescriberClient,
      RecipeExecutorClient executorClient,
      RecipePatientClient patientClient) {
    this.prescriberClient = prescriberClient;
    this.executorClient = executorClient;
    this.patientClient = patientClient;
  }

  @Override
  public Prescription.Encrypted add(
      CreatePrescription<Prescription.Encrypted.Specification> request) {
    return prescriberClient.add(request);
  }

  @Override
  public Prescription.Encrypted get(be.recipe.api.prescriber.GetPrescription request) {
    return prescriberClient.get(request);
  }

  @Override
  public be.recipe.api.prescriber.ListPrescriptions.PartialResult<
          be.recipe.api.prescriber.ListPrescriptions.Response.Encrypted>
      list(be.recipe.api.prescriber.ListPrescriptions request) {
    return prescriberClient.list(request);
  }

  @Override
  public be.recipe.api.series.PartialResult<ListPrescriptions.Response.Encrypted> list(
      ListPrescriptions request) {
    return executorClient.list(request);
  }

  @Override
  public Prescription.Encrypted get(GetPrescription request) {
    return executorClient.get(request);
  }

  @Override
  public Prescription.Encrypted getAndPutInProcess(GetPrescriptionAndPutInProcess request) {
    return executorClient.getAndPutInProcess(request);
  }

  @Override
  public be.recipe.api.series.PartialResult<be.recipe.api.patient.ListPrescriptions.Response.Encrypted> list(
      be.recipe.api.patient.ListPrescriptions request) {
    return patientClient.list(request);
  }

  @Override
  public void update(PutVisionExecutors.Request request) {
    patientClient.update(request);
  }

  @Override
  public void update(PutVisionOtherPrescribers request) {
    prescriberClient.update(request);
  }

  @Override
  public GetExecutorProfile.Response getProfile(GetExecutorProfile request) {
    return patientClient.getProfile(request);
  }

  @Override
  public void updateProfile(UpdateProfile request) {
    executorClient.updateProfile(request);
  }

  @Override
  public GetProfile.Response getProfile(GetProfile request) {
    return executorClient.getProfile(request);
  }

  @Override
  public  Prescription.Encrypted get(
      be.recipe.api.patient.GetPrescription request) {
    return patientClient.get(request);
  }

  @Override
  public void update(RevokePrescription request) {
    prescriberClient.update(request);
  }

  @Override
  public void update(ArchivePrescription request) {
    executorClient.update(request);
  }

  @Override
  public void update(be.recipe.api.patient.RevokePrescription request) {
    patientClient.update(request);
  }

  @Override
  public void update(be.recipe.api.patient.PutVisionOtherPrescribers request) {
    patientClient.update(request);
  }

  @Override
  public GetPrescriptionStatusResponse get(be.recipe.api.prescriber.GetPrescriptionStatus request) {
    return prescriberClient.get(request);
  }

  @Override
  public GetPrescriptionStatusResponse get(be.recipe.api.executor.GetPrescriptionStatus request) {
    return executorClient.get(request);
  }

  @Override
  public GetPrescriptionStatusResponse get(be.recipe.api.patient.GetPrescriptionStatus request) {
    return patientClient.get(request);
  }
}
