/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.common.exceptions;

import be.recipe.common.exceptions.RecipeError;
import be.recipe.common.exceptions.RecipeException;
import be.recipe.common.exceptions.RecipeExceptionDetails;
import be.recipe.utils.UTF8Control;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeExceptionFactory {
    public static final String RESOURCE_BUNDLE = "RecipeErrors";
    public static final Locale DUTCH_LOCALE = new Locale("nl", "BE");
    public static final Locale FRENCH_LOCALE = new Locale("fr", "FR");
    public static final Locale ENGLISH_LOCALE = Locale.ENGLISH;
    private static final Logger LOG = LoggerFactory.getLogger(RecipeExceptionFactory.class);
    public static final String SEPERATOR = ";";
    public static final Locale[] LOCALES = new Locale[]{ENGLISH_LOCALE, DUTCH_LOCALE, FRENCH_LOCALE};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecipeException createException(String errorCode, Object[] context) {
        RecipeExceptionDetails recipeDetails = RecipeExceptionFactory.getRecipeDetails(errorCode, context);
        String message = errorCode;
        try {
            RecipeExceptionDetails.ErrorMap errorMap = recipeDetails.getErrorMap();
            for (RecipeExceptionDetails.ErrorMap.Entry entry : errorMap.entries) {
                if (!entry.key.equals("en")) continue;
                message = entry.value.getMessage();
                break;
            }
        }
        finally {
            LOG.error("Error: " + message);
        }
        return new RecipeException(message, recipeDetails);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecipeException createException(Object[] context, String errorCode) {
        RecipeExceptionDetails recipeDetails = RecipeExceptionFactory.getRecipeDetails(errorCode, context);
        String message = errorCode;
        try {
            RecipeExceptionDetails.ErrorMap errorMap = recipeDetails.getErrorMap();
            for (RecipeExceptionDetails.ErrorMap.Entry entry : errorMap.entries) {
                if (!entry.key.equals("en")) continue;
                message = entry.value.getMessage();
                break;
            }
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            LOG.error("Erro: " + message);
        }
        return new RecipeException(message, recipeDetails);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecipeException createException(String errorCode, Object[] context, Throwable cause) {
        if (cause instanceof RecipeException) {
            return (RecipeException)cause;
        }
        RecipeExceptionDetails recipeDetails = RecipeExceptionFactory.getRecipeDetails(errorCode, context);
        String message = errorCode;
        try {
            RecipeExceptionDetails.ErrorMap errorMap = recipeDetails.getErrorMap();
            for (RecipeExceptionDetails.ErrorMap.Entry entry : errorMap.entries) {
                if (!entry.key.equals("en")) continue;
                message = entry.value.getMessage();
                break;
            }
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            LOG.error("Error: " + message);
        }
        return new RecipeException(message, recipeDetails);
    }

    private static RecipeExceptionDetails getRecipeDetails(String errorCode, Object[] context) {
        RecipeExceptionDetails.ErrorMap errorMap = new RecipeExceptionDetails.ErrorMap();
        for (Locale loc : LOCALES) {
            RecipeExceptionDetails.ErrorMap.Entry entry = new RecipeExceptionDetails.ErrorMap.Entry();
            entry.setKey(loc.getLanguage());
            be.recipe.services.core.RecipeError re = new be.recipe.services.core.RecipeError();
            re.setMessage(RecipeExceptionFactory.getI18nMessage(errorCode, loc, context).getMessage());
            entry.setValue(re);
            errorMap.entries.add(entry);
        }
        RecipeExceptionDetails red = new RecipeExceptionDetails();
        red.setCode(errorCode);
        red.setErrorMap(errorMap);
        return red;
    }

    private static RecipeError getI18nMessage(String errorCode, Locale locale, Object[] context) {
        if (locale == null) {
            locale = ENGLISH_LOCALE;
        }
        Locale.setDefault(locale);
        try {
            ResourceBundle rb = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, (ResourceBundle.Control)new UTF8Control());
            if (rb != null && rb.containsKey(errorCode)) {
                String msg = rb.getString(errorCode);
                return new RecipeError(MessageFormat.format(msg, context));
            }
        }
        catch (MissingResourceException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return new RecipeError("!!! " + errorCode + " !!!");
    }
}

