/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.utils.prescribercreatebulkprescriptions;

import be.business.connector.common.ehealth.EhealthKeyRegistry;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.ETKHelper;
import be.business.connector.core.utils.EncryptionUtils;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.core.utils.SessionValidator;
import be.business.connector.recipe.prescriber.AbstractPrescriberIntegrationModule;
import be.business.connector.recipe.prescriber.dto.CreatePrescriptionDTO;
import be.business.connector.recipe.utils.prescribercreatebulkprescriptions.CreateEncryptedPrescriptionsJavaThread;
import be.business.connector.recipe.utils.prescribercreatebulkprescriptions.CreateEncryptedPrescriptionsTask;
import be.business.connector.recipe.utils.prescribercreatebulkprescriptions.CreateEncryptedPrescriptionsThread;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.ehealth.technicalconnector.service.sts.security.impl.KeyPairCredential;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionItem;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.recipe.api.crypto.Message;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PrescriberCreateBulkPrescriptionsUseCase {
    private static final Logger LOG = LoggerFactory.getLogger(PrescriberCreateBulkPrescriptionsUseCase.class);
    private final ETKHelper etkHelper;
    private final Map<String, KeyResult> keyCache;
    private final EhealthKeyRegistry keyRegistry;
    private final Key symmKey;

    public PrescriberCreateBulkPrescriptionsUseCase(PropertyHandler propertyHandler, EncryptionUtils encryptionUtils, Map<String, KeyResult> keyCache) {
        this.etkHelper = new ETKHelper(propertyHandler, encryptionUtils);
        this.symmKey = EncryptionUtils.getInstance().generateSecretKey();
        this.keyCache = keyCache;
        this.keyRegistry = new EhealthKeyRegistry(propertyHandler);
        this.keyRegistry.refresh(this.etkHelper, propertyHandler);
    }

    public List<CreatePrescriptionDTO> execute(List<CreatePrescriptionDTO> createPrescriptionDTOs, AbstractPrescriberIntegrationModule prescriberIntegrationModuleV4) throws TechnicalConnectorException {
        long startCreating = System.currentTimeMillis();
        int threadLimit = PropertyHandler.getInstance().getIntegerProperty("encryption.thread.number", "50");
        Semaphore semaphore = new Semaphore(threadLimit, true);
        ArrayList<CreateEncryptedPrescriptionsJavaThread> dataList = new ArrayList<CreateEncryptedPrescriptionsJavaThread>();
        SessionItem sessionItem = Session.getInstance().getSession();
        SessionValidator.assertValidSession(sessionItem);
        Element assertion = sessionItem.getSAMLToken().getAssertion();
        KeyPairCredential keyPairCredential = PrescriberCreateBulkPrescriptionsUseCase.getKeyPairCredentialFromSession(sessionItem);
        for (CreatePrescriptionDTO createPrescriptionDTO : createPrescriptionDTOs) {
            if (createPrescriptionDTO.getPrescription() == null) continue;
            KeyResult keyResult = this.getNewKey(createPrescriptionDTO.getPatientId());
            EncryptionToken recipeEtk = this.etkHelper.getRecipe_ETK().get(0);
            CreateEncryptedPrescriptionsTask task = new CreateEncryptedPrescriptionsTask(semaphore, createPrescriptionDTO, keyResult, this.symmKey, recipeEtk, prescriberIntegrationModuleV4, assertion, keyPairCredential);
            CreateEncryptedPrescriptionsJavaThread encryptorThread = new CreateEncryptedPrescriptionsJavaThread(task);
            dataList.add(encryptorThread);
        }
        for (CreateEncryptedPrescriptionsThread createEncryptedPrescriptionsThread : dataList) {
            semaphore.acquireUninterruptibly();
            createEncryptedPrescriptionsThread.execute();
        }
        try {
            semaphore.acquireUninterruptibly(threadLimit);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Incorrect Thread configuration : " + e);
            throw new IntegrationModuleException(e.getMessage(), e);
        }
        ArrayList<CreatePrescriptionDTO> finalResult = new ArrayList<CreatePrescriptionDTO>();
        for (CreateEncryptedPrescriptionsThread createEncryptedPrescriptionsThread : dataList) {
            try {
                LOG.info("Ending thread {} at {}", (Object)createEncryptedPrescriptionsThread.getName(), (Object)System.currentTimeMillis());
                createEncryptedPrescriptionsThread.join();
            }
            catch (InterruptedException e) {
                throw new IntegrationModuleException(e);
            }
            finalResult.add(createEncryptedPrescriptionsThread.getData());
        }
        for (CreatePrescriptionDTO createPrescriptionDTO : createPrescriptionDTOs) {
            for (CreatePrescriptionDTO finalDTO : finalResult) {
                if (createPrescriptionDTO.getSequenceNumber() != finalDTO.getSequenceNumber()) continue;
                createPrescriptionDTO.setRid(finalDTO.getRid());
                createPrescriptionDTO.setErrorOccured(finalDTO.isErrorOccured());
                createPrescriptionDTO.setException(finalDTO.getException());
                if (!finalDTO.isErrorOccured()) continue;
                LOG.info(String.format("Error occured during doEncryptions-operations[%s]:[%s] ", finalDTO.getSequenceNumber(), finalDTO.getException()));
            }
        }
        long l = System.currentTimeMillis();
        LOG.debug("Creating {} prescriptions in bulk took {} ms", (Object)createPrescriptionDTOs.size(), (Object)(l - startCreating));
        return createPrescriptionDTOs;
    }

    private static KeyPairCredential getKeyPairCredentialFromSession(SessionItem sessionItem) {
        try {
            return new KeyPairCredential(sessionItem.getHolderOfKeyCredential().getPrivateKey(), sessionItem.getHolderOfKeyCredential().getCertificate());
        }
        catch (TechnicalConnectorException e) {
            LOG.error("Error generic webservice", (Throwable)e);
            throw new IntegrationModuleException(e);
        }
    }

    private KeyResult getNewKey(String patientId) {
        KeyResult key;
        if (this.keyCache.containsKey(patientId)) {
            key = this.keyCache.get(patientId);
        } else {
            key = this.getNewKeyFromKgss(patientId);
            this.keyCache.put(patientId, key);
        }
        return key;
    }

    @Profiled(logFailuresSeparately=true, tag="0.PrescriberIntegrationModule#getNewKeyFromKgss")
    protected KeyResult getNewKeyFromKgss(String patientId) {
        Message.Cipher.Key key = this.keyRegistry.create(patientId);
        return new KeyResult(key.secret(), key.id().toString());
    }
}

