/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.utils.executorlistopenprescriptions;

import be.business.connector.common.StandaloneRequestorProvider;
import be.business.connector.core.domain.KgssIdentifierType;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.technical.connector.utils.Crypto;
import be.business.connector.core.utils.ETKHelper;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.recipe.executor.dto.ListOpenPrescriptionsResultWithExceptions;
import be.business.connector.recipe.utils.executorlistopenprescriptions.DecryptPrescriptionJavaThread;
import be.business.connector.recipe.utils.executorlistopenprescriptions.DecryptPrescriptionTask;
import be.business.connector.recipe.utils.executorlistopenprescriptions.DecryptPrescriptionThread;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.kgss.impl.KgssServiceImpl;
import be.ehealth.technicalconnector.service.sts.security.impl.KeyPairCredential;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionItem;
import be.fgov.ehealth.etee.kgss._1_0.protocol.GetKeyRequestContent;
import be.recipe.services.executor.GetOpenPrescriptionForExecutor;
import be.recipe.services.executor.ListOpenPrescriptionsResult;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class MultiThreadedExecutorListOpenPrescriptionsUseCase {
    private final ETKHelper etkHelper;
    private static final Logger LOG = LoggerFactory.getLogger(MultiThreadedExecutorListOpenPrescriptionsUseCase.class);

    public MultiThreadedExecutorListOpenPrescriptionsUseCase(ETKHelper etkHelper) {
        this.etkHelper = etkHelper;
    }

    public ListOpenPrescriptionsResult execute(ListOpenPrescriptionsResult listOpenPrescriptionsResult) throws IntegrationModuleException {
        if (listOpenPrescriptionsResult == null || CollectionUtils.isEmpty((Collection)listOpenPrescriptionsResult.getPrescriptions())) {
            return listOpenPrescriptionsResult;
        }
        return this.doDecryptions(listOpenPrescriptionsResult);
    }

    public ListOpenPrescriptionsResultWithExceptions executeWithExceptions(ListOpenPrescriptionsResult listOpenPrescriptionsResult) throws IntegrationModuleException {
        if (listOpenPrescriptionsResult == null || CollectionUtils.isEmpty((Collection)listOpenPrescriptionsResult.getPrescriptions())) {
            return new ListOpenPrescriptionsResultWithExceptions();
        }
        Map<GetOpenPrescriptionForExecutor, DecryptPrescriptionThread> dataMap = this.createThreads(listOpenPrescriptionsResult);
        ListOpenPrescriptionsResultWithExceptions result = new ListOpenPrescriptionsResultWithExceptions();
        for (DecryptPrescriptionThread thread : dataMap.values()) {
            result.addPrescription(thread.getPrescription(), thread.getError());
        }
        result.setHasMoreResults(listOpenPrescriptionsResult.isHasMoreResults());
        result.setSession(listOpenPrescriptionsResult.getSession());
        return result;
    }

    private Map<GetOpenPrescriptionForExecutor, DecryptPrescriptionThread> createThreads(ListOpenPrescriptionsResult listOpenPrescriptionsResult) {
        KeyPairCredential holderOfKeyCredential;
        KeyPairCredential encryptionCredential;
        HashMap<GetOpenPrescriptionForExecutor, DecryptPrescriptionThread> dataMap = new HashMap<GetOpenPrescriptionForExecutor, DecryptPrescriptionThread>();
        int threadLimit = PropertyHandler.getInstance().getIntegerProperty("decryption.thread.number", "50");
        Semaphore semaphore = new Semaphore(threadLimit, true);
        byte[] pharmacyEtk = this.getPharmacyEtkAsBytes();
        byte[] kgssEtk = this.etkHelper.getKGSS_ETK().get(0).getEncoded();
        KgssServiceImpl kgssService = new KgssServiceImpl();
        GetKeyRequestContent getKeyRequestContent = new GetKeyRequestContent();
        getKeyRequestContent.setETK(pharmacyEtk);
        SessionItem sessionItem = Session.getInstance().getSession();
        try {
            encryptionCredential = new KeyPairCredential(sessionItem.getEncryptionCredential().getPrivateKey(), sessionItem.getEncryptionCredential().getCertificate());
            holderOfKeyCredential = new KeyPairCredential(sessionItem.getHolderOfKeyCredential().getPrivateKey(), sessionItem.getHolderOfKeyCredential().getCertificate());
        }
        catch (TechnicalConnectorException e) {
            throw new IntegrationModuleException(e);
        }
        Element samlAssertion = sessionItem.getSAMLToken().getAssertion();
        Map encryptionPrivateKeys = sessionItem.getEncryptionPrivateKeys();
        Crypto crypto = new Crypto();
        kgssService.bootstrap();
        for (GetOpenPrescriptionForExecutor getOpenPrescription : listOpenPrescriptionsResult.getPrescriptions()) {
            if (getOpenPrescription.getPrescription() == null) continue;
            DecryptPrescriptionTask task = new DecryptPrescriptionTask(getOpenPrescription, semaphore, pharmacyEtk, kgssEtk, encryptionCredential, holderOfKeyCredential, samlAssertion, encryptionPrivateKeys, kgssService, crypto);
            dataMap.put(getOpenPrescription, new DecryptPrescriptionJavaThread(task));
        }
        for (DecryptPrescriptionThread decryptPrescriptionThread : dataMap.values()) {
            semaphore.acquireUninterruptibly();
            decryptPrescriptionThread.execute();
        }
        try {
            semaphore.acquireUninterruptibly(threadLimit);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Incorrect Thread configuration : " + e);
        }
        return dataMap;
    }

    private byte[] getPharmacyEtkAsBytes() {
        return this.etkHelper.getEtks(KgssIdentifierType.NIHII_PHARMACY, StandaloneRequestorProvider.getRequestorIdInformation()).get(0).getEncoded();
    }

    private ListOpenPrescriptionsResult doDecryptions(ListOpenPrescriptionsResult prescriptionList) {
        Map<GetOpenPrescriptionForExecutor, DecryptPrescriptionThread> dataMap = this.createThreads(prescriptionList);
        ListOpenPrescriptionsResult finalResult = new ListOpenPrescriptionsResult();
        for (DecryptPrescriptionThread thread : dataMap.values()) {
            finalResult.getPrescriptions().add(thread.getPrescription());
        }
        finalResult.setHasMoreResults(prescriptionList.isHasMoreResults());
        finalResult.setSession(prescriptionList.getSession());
        Collections.sort(finalResult.getPrescriptions(), new Comparator<GetOpenPrescriptionForExecutor>(){

            @Override
            public int compare(GetOpenPrescriptionForExecutor f1, GetOpenPrescriptionForExecutor f2) {
                return f2.getCreationDate().compareTo(f1.getCreationDate());
            }
        });
        return finalResult;
    }
}

