/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.utils.executorlistopenprescriptions;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.technical.connector.utils.Crypto;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.IOUtils;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.ehealth.technicalconnector.service.kgss.impl.KgssServiceImpl;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.impl.KeyPairCredential;
import be.fgov.ehealth.etee.kgss._1_0.protocol.GetKeyRequestContent;
import be.fgov.ehealth.etee.kgss._1_0.protocol.GetKeyResponseContent;
import be.recipe.services.executor.GetOpenPrescriptionForExecutor;
import java.security.PrivateKey;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DecryptPrescriptionTask {
    private static final Logger LOG = LoggerFactory.getLogger(DecryptPrescriptionTask.class);
    private GetOpenPrescriptionForExecutor prescription;
    private Semaphore semaphore;
    private byte[] pharmacyEtk;
    private byte[] kgssEtk;
    private final KeyPairCredential encryptionCredential;
    private final KeyPairCredential holderOfKeyCredential;
    private final Element samlAssertion;
    private final Map<String, PrivateKey> encryptionPrivateKeys;
    private final KgssServiceImpl kgssService;
    private IntegrationModuleException error;
    private final Crypto crypto;

    public DecryptPrescriptionTask(GetOpenPrescriptionForExecutor prescription, Semaphore semaphore, byte[] pharmacyEtk, byte[] kgssEtk, KeyPairCredential encryptionCredential, KeyPairCredential holderOfKeyCredential, Element samlAssertion, Map<String, PrivateKey> encryptionPrivateKeys, KgssServiceImpl kgssService, Crypto crypto) {
        this.prescription = prescription;
        this.semaphore = semaphore;
        this.pharmacyEtk = pharmacyEtk;
        this.kgssEtk = kgssEtk;
        this.encryptionCredential = encryptionCredential;
        this.holderOfKeyCredential = holderOfKeyCredential;
        this.samlAssertion = samlAssertion;
        this.encryptionPrivateKeys = encryptionPrivateKeys;
        this.kgssService = kgssService;
        this.crypto = crypto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            LOG.debug("Starting decrypt prescription task at {}", (Object)System.currentTimeMillis());
            long startRetrieveKgssKey = System.currentTimeMillis();
            GetKeyRequestContent getKeyRequestContent = new GetKeyRequestContent();
            getKeyRequestContent.setETK(this.pharmacyEtk);
            String keyId = this.prescription.getEncryptionKeyId();
            getKeyRequestContent.setKeyIdentifier(Base64.decodeBase64((String)keyId));
            GetKeyResponseContent keyResponse = this.kgssService.getKey(getKeyRequestContent, (Credential)this.holderOfKeyCredential, (Credential)this.encryptionCredential, this.samlAssertion, this.encryptionPrivateKeys, this.kgssEtk);
            KeyResult keyResult = new KeyResult((SecretKey)new SecretKeySpec(keyResponse.getKey(), "AES"), keyId);
            long endRetrieveKgssKey = System.currentTimeMillis();
            LOG.debug("Retrieve KGSS key took {} ms", (Object)(endRetrieveKgssKey - startRetrieveKgssKey));
            long startUnseal = System.currentTimeMillis();
            byte[] unsealedPrescription = this.crypto.unsealForUnknown(keyResult, this.prescription.getPrescription());
            long endUnseal = System.currentTimeMillis();
            LOG.debug("Unsealing prescription took {} ms", (Object)(endUnseal - startUnseal));
            this.prescription.setPrescription(IOUtils.decompress(unsealedPrescription));
        }
        catch (Exception e) {
            this.error = new IntegrationModuleException(I18nHelper.getLabel("technical.connector.error.retrieve.key"), e);
        }
        finally {
            this.semaphore.release();
            LOG.debug("Ending decrypt prescription task at {}", (Object)System.currentTimeMillis());
        }
    }

    public GetOpenPrescriptionForExecutor getPrescription() {
        return this.prescription;
    }

    public IntegrationModuleException getError() {
        return this.error;
    }
}

