/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.patient.utils;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.ETKHelper;
import be.business.connector.core.utils.EncryptionUtils;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.recipe.patient.utils.PatientPrescriptionDecryptorThread;
import be.recipe.services.patient.GetOpenPrescriptionForPatient;
import be.recipe.services.patient.ListPatientPrescriptionsResult;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import org.apache.commons.collections.CollectionUtils;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatientDecryptionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PatientDecryptionUtils.class);
    private final ETKHelper etkHelper;

    public PatientDecryptionUtils(PropertyHandler propertyHandler, EncryptionUtils encryptionUtils) {
        this.etkHelper = new ETKHelper(propertyHandler, encryptionUtils);
    }

    @Profiled(logFailuresSeparately=true, tag="0.DecompressionUtil#decryptPrescriptions")
    public ListPatientPrescriptionsResult decryptPrescriptions(ListPatientPrescriptionsResult listPatientPrescriptionsResult) throws IntegrationModuleException {
        if (listPatientPrescriptionsResult == null || listPatientPrescriptionsResult != null && CollectionUtils.isEmpty((Collection)listPatientPrescriptionsResult.getPrescriptions())) {
            return listPatientPrescriptionsResult;
        }
        return this.doDecryptions(listPatientPrescriptionsResult);
    }

    private ListPatientPrescriptionsResult doDecryptions(ListPatientPrescriptionsResult prescriptionList) {
        int threadLimit = PropertyHandler.getInstance().getIntegerProperty("decryption.thread.number", "50");
        Semaphore semaphore = new Semaphore(threadLimit, true);
        HashMap<GetOpenPrescriptionForPatient, PatientPrescriptionDecryptorThread> dataMap = new HashMap<GetOpenPrescriptionForPatient, PatientPrescriptionDecryptorThread>();
        byte[] patientEtk = this.etkHelper.getSystemETK().get(0).getEncoded();
        byte[] kgssEtk = this.etkHelper.getKGSS_ETK().get(0).getEncoded();
        for (GetOpenPrescriptionForPatient getOpenPrescription : prescriptionList.getPrescriptions()) {
            if (getOpenPrescription.getPrescription() == null) continue;
            PatientPrescriptionDecryptorThread decryptorThread = new PatientPrescriptionDecryptorThread(semaphore, getOpenPrescription, patientEtk, kgssEtk);
            dataMap.put(getOpenPrescription, decryptorThread);
        }
        for (PatientPrescriptionDecryptorThread decryptorThread : dataMap.values()) {
            semaphore.acquireUninterruptibly();
            decryptorThread.start();
        }
        try {
            semaphore.acquireUninterruptibly(threadLimit);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Incorrect Thread configuration : " + e);
        }
        ListPatientPrescriptionsResult finalResult = new ListPatientPrescriptionsResult();
        for (PatientPrescriptionDecryptorThread decryptorThread : dataMap.values()) {
            finalResult.getPrescriptions().add(decryptorThread.getPrescription());
        }
        finalResult.setHasMoreResults(prescriptionList.isHasMoreResults());
        Collections.sort(finalResult.getPrescriptions(), new Comparator<GetOpenPrescriptionForPatient>(){

            @Override
            public int compare(GetOpenPrescriptionForPatient f1, GetOpenPrescriptionForPatient f2) {
                return f2.getCreationDate().compareTo(f1.getCreationDate());
            }
        });
        return finalResult;
    }
}

