/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.patient;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.Exceptionutils;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.MarshallerHelper;
import be.business.connector.recipe.AbstractRecipeClient;
import be.business.connector.recipe.patient.AbstractPatientIntegrationModule;
import be.business.connector.recipe.patient.PatientIntegrationModuleDevV4;
import be.business.connector.recipe.patient.services.RecipePatientServiceDevV4Impl;
import be.business.connector.recipe.utils.RidValidator;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.recipe.services.core.ResponseType;
import be.recipe.services.patient.CreateReservation;
import be.recipe.services.patient.CreateReservationParam;
import be.recipe.services.patient.CreateReservationResponse;
import be.recipe.services.patient.CreateReservationResult;
import be.recipe.services.patient.GetPrescriptionForPatient;
import be.recipe.services.patient.GetPrescriptionForPatientResponse;
import be.recipe.services.patient.GetPrescriptionForPatientResult;
import be.recipe.services.patient.GetPrescriptionStatus;
import be.recipe.services.patient.GetPrescriptionStatusParam;
import be.recipe.services.patient.GetPrescriptionStatusResponse;
import be.recipe.services.patient.GetPrescriptionStatusResult;
import be.recipe.services.patient.GetVision;
import be.recipe.services.patient.GetVisionParam;
import be.recipe.services.patient.GetVisionResponse;
import be.recipe.services.patient.GetVisionResult;
import be.recipe.services.patient.ListOpenRids;
import be.recipe.services.patient.ListOpenRidsParam;
import be.recipe.services.patient.ListOpenRidsResponse;
import be.recipe.services.patient.ListOpenRidsResult;
import be.recipe.services.patient.ListPatientPrescription;
import be.recipe.services.patient.ListPatientPrescriptionResponse;
import be.recipe.services.patient.ListPatientPrescriptionsParam;
import be.recipe.services.patient.ListPatientPrescriptionsResult;
import be.recipe.services.patient.PutVision;
import be.recipe.services.patient.PutVisionParam;
import be.recipe.services.patient.PutVisionResponse;
import be.recipe.services.patient.PutVisionResult;
import be.recipe.services.patient.RevokePrescription;
import be.recipe.services.patient.RevokePrescriptionResponse;
import be.recipe.services.patient.RevokePrescriptionResult;
import java.util.List;
import java.util.UUID;
import javax.xml.ws.WebServiceException;
import org.perf4j.aop.Profiled;

public class PatientIntegrationModuleDevV4Impl
extends AbstractPatientIntegrationModule
implements PatientIntegrationModuleDevV4 {
    @Override
    public void revokePrescription(String rid, String reason) {
        RidValidator.validateRid(rid);
        try {
            byte[] sealedRevokePrescriptionParam = this.getSealedRevokePrescriptionParam(rid, reason);
            RevokePrescription request = new RevokePrescription();
            request.setRevokePrescriptionParamSealed(sealedRevokePrescriptionParam);
            request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setMguid(UUID.randomUUID().toString());
            try {
                RevokePrescriptionResponse response = RecipePatientServiceDevV4Impl.getInstance().revokePrescription(request);
                MarshallerHelper<RevokePrescriptionResult, RevokePrescriptionResult> helper = new MarshallerHelper<RevokePrescriptionResult, RevokePrescriptionResult>(RevokePrescriptionResult.class, RevokePrescriptionResult.class);
                RevokePrescriptionResult result = helper.unsealWithSymmKey(response.getRevokePrescriptionResultSealed(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
        }
    }

    @Override
    public GetPrescriptionForPatientResult getPrescription(String rid) {
        RidValidator.validateRid(rid);
        try {
            byte[] sealedContent = this.getSealedGetPrescriptionForPatientParam(rid);
            GetPrescriptionForPatient request = new GetPrescriptionForPatient();
            request.setGetPrescriptionForPatientParamSealed(sealedContent);
            request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setMguid(UUID.randomUUID().toString());
            GetPrescriptionForPatientResponse response = null;
            try {
                response = RecipePatientServiceDevV4Impl.getInstance().getPrescriptionForPatient(request);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
            GetPrescriptionForPatientResult finalResult = this.unsealPrescription(response.getGetPrescriptionForPatientResultSealed());
            return finalResult;
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PatientIntegrationModuleV4#getData(GetVisionParam)")
    public GetVisionResult getData(GetVisionParam data) {
        RidValidator.validateRid(data.getRid());
        try {
            GetVision request = this.getVisionRequest(data);
            try {
                GetVisionResponse getDataResponse = RecipePatientServiceDevV4Impl.getInstance().getVision(request);
                GetVisionResult getVisionResult = this.unsealGetVisionResponse(getDataResponse);
                this.checkStatus((ResponseType)getVisionResult);
                return getVisionResult;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    private GetVisionResult unsealGetVisionResponse(GetVisionResponse getVisionResponse) {
        MarshallerHelper<GetVisionResult, Object> marshaller = new MarshallerHelper<GetVisionResult, Object>(GetVisionResult.class, Object.class);
        GetVisionResult result = marshaller.unsealWithSymmKey(getVisionResponse.getGetVisionResultSealed(), this.getSymmKey());
        return result;
    }

    private PutVisionResult unsealPutVisionResponse(PutVisionResponse putVisionResponse) {
        MarshallerHelper<PutVisionResult, Object> marshaller = new MarshallerHelper<PutVisionResult, Object>(PutVisionResult.class, Object.class);
        PutVisionResult result = marshaller.unsealWithSymmKey(putVisionResponse.getPutVisionResultSealed(), this.getSymmKey());
        return result;
    }

    private CreateReservationResult unsealCreateReservationResponse(CreateReservationResponse dataResponse) {
        MarshallerHelper<CreateReservationResult, Object> marshaller = new MarshallerHelper<CreateReservationResult, Object>(CreateReservationResult.class, Object.class);
        CreateReservationResult result = marshaller.unsealWithSymmKey(dataResponse.getCreateReservationResultSealed(), this.getSymmKey());
        return result;
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PatientIntegrationModuleV4#putVision")
    public PutVisionResult putData(PutVisionParam putVisionParam) {
        RidValidator.validateRid(putVisionParam.getRid());
        try {
            PutVision request = this.putVision(putVisionParam);
            try {
                PutVisionResponse response = RecipePatientServiceDevV4Impl.getInstance().putVision(request);
                PutVisionResult result = this.unsealPutVisionResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PatientIntegrationModuleV4#putReservation")
    public CreateReservationResult putData(CreateReservationParam data) {
        RidValidator.validateRid(data.getRid());
        try {
            CreateReservation putReservation = this.putReservationRequest(data);
            try {
                CreateReservationResponse response = RecipePatientServiceDevV4Impl.getInstance().createReservation(putReservation);
                CreateReservationResult result = this.unsealCreateReservationResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    @Override
    public ListPatientPrescriptionsResult listOpenPrescriptions(ListPatientPrescriptionsParam listPatientPrescriptionsParam) {
        try {
            MarshallerHelper<ListPatientPrescriptionsResult, ListPatientPrescriptionsParam> helper = new MarshallerHelper<ListPatientPrescriptionsResult, ListPatientPrescriptionsParam>(ListPatientPrescriptionsResult.class, ListPatientPrescriptionsParam.class);
            List<EncryptionToken> etkRecipes = this.getEtkHelper().getRecipe_ETK();
            ListPatientPrescriptionsParam param = new ListPatientPrescriptionsParam();
            param.setSymmKey(this.getSymmKey().getEncoded());
            ListPatientPrescription request = new ListPatientPrescription();
            request.setListPatientPrescriptionsParamSealed(this.sealRequest(etkRecipes.get(0), helper.toXMLByteArray(param)));
            request.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setMguid(UUID.randomUUID().toString());
            ListPatientPrescriptionResponse response = null;
            try {
                response = RecipePatientServiceDevV4Impl.getInstance().listOpenPrescriptions(request);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.prescriber"), cte);
            }
            ListPatientPrescriptionsResult result = helper.unsealWithSymmKey(response.getListPatientPrescriptionsResultSealed(), this.getSymmKey());
            this.checkStatus((ResponseType)result);
            return result;
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PatientIntegrationModuleV4#getData(GetPrescriptionStatusParam)")
    public GetPrescriptionStatusResult getData(GetPrescriptionStatusParam data) {
        RidValidator.validateRid(data.getRid());
        try {
            GetPrescriptionStatus getPrescriptionStatus = this.getGetPrescriptionStatusRequest(data);
            try {
                GetPrescriptionStatusResponse response = RecipePatientServiceDevV4Impl.getInstance().getPrescriptionStatus(getPrescriptionStatus);
                GetPrescriptionStatusResult result = this.unsealGetPrescriptionStatusResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    private GetPrescriptionStatusResult unsealGetPrescriptionStatusResponse(GetPrescriptionStatusResponse response) {
        MarshallerHelper<GetPrescriptionStatusResult, Object> marshaller = new MarshallerHelper<GetPrescriptionStatusResult, Object>(GetPrescriptionStatusResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getGetPrescriptionStatusResultSealed(), this.getSymmKey());
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.PatientIntegrationModuleV4#getData(ListOpenPrescriptionsParam)")
    public ListOpenRidsResult getData(ListOpenRidsParam data) {
        try {
            ListOpenRids request = this.getListOpenRids(data);
            try {
                ListOpenRidsResponse getDataResponse = RecipePatientServiceDevV4Impl.getInstance().listOpenRids(request);
                ListOpenRidsResult unsealedResponse = this.unsealListOpenPrescriptionResponse(getDataResponse);
                this.checkStatus((ResponseType)unsealedResponse);
                return unsealedResponse;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    private ListOpenRidsResult unsealListOpenPrescriptionResponse(ListOpenRidsResponse response) {
        MarshallerHelper<ListOpenRidsResult, Object> marshaller = new MarshallerHelper<ListOpenRidsResult, Object>(ListOpenRidsResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getListOpenRidsResultSealed(), this.getSymmKey());
    }

    protected GetVision getVisionRequest(GetVisionParam data) {
        data.setSymmKey(this.getSymmKey().getEncoded());
        GetVision getVision = new GetVision();
        getVision.setGetVisionParamSealed(this.getSealedData(data));
        getVision.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        getVision.setMguid(UUID.randomUUID().toString());
        return getVision;
    }

    protected PutVision putVision(PutVisionParam data) {
        data.setSymmKey(this.getSymmKey().getEncoded());
        PutVision putVision = new PutVision();
        putVision.setPutVisionParamSealed(this.getSealedData(data));
        putVision.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        putVision.setMguid(UUID.randomUUID().toString());
        return putVision;
    }

    protected CreateReservation putReservationRequest(CreateReservationParam data) {
        data.setSymmKey(this.getSymmKey().getEncoded());
        CreateReservation putReservation = new CreateReservation();
        putReservation.setCreateReservationParamSealed(this.getSealedData(data));
        putReservation.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        putReservation.setMguid(UUID.randomUUID().toString());
        return putReservation;
    }

    protected GetPrescriptionStatus getGetPrescriptionStatusRequest(GetPrescriptionStatusParam data) {
        data.setSymmKey(this.getSymmKey().getEncoded());
        GetPrescriptionStatus getPrescriptionStatus = new GetPrescriptionStatus();
        getPrescriptionStatus.setGetPrescriptionStatusParamSealed(this.getSealedData(data));
        getPrescriptionStatus.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        getPrescriptionStatus.setMguid(UUID.randomUUID().toString());
        return getPrescriptionStatus;
    }

    protected ListOpenRids getListOpenRids(ListOpenRidsParam data) {
        data.setSymmKey(this.getSymmKey().getEncoded());
        ListOpenRids listOpenPrescription = new ListOpenRids();
        listOpenPrescription.setListOpenRidsParamSealed(this.getSealedData(data));
        listOpenPrescription.setProgramIdentification(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        listOpenPrescription.setMguid(UUID.randomUUID().toString());
        return listOpenPrescription;
    }

    private byte[] getSealedData(GetPrescriptionStatusParam request) {
        request.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(request, GetPrescriptionStatusParam.class);
    }

    private byte[] getSealedData(ListOpenRidsParam request) {
        request.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(request, ListOpenRidsParam.class);
    }

    private byte[] getSealedData(CreateReservationParam request) {
        request.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(request, CreateReservationParam.class);
    }

    private byte[] getSealedData(GetVisionParam request) {
        request.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(request, GetVisionParam.class);
    }

    private byte[] getSealedData(PutVisionParam request) {
        request.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(request, PutVisionParam.class);
    }
}

