/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.recipe.executor;

import be.business.connector.common.ApplicationConfig;
import be.business.connector.common.StandaloneRequestorProvider;
import be.business.connector.core.domain.KgssIdentifierType;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.Exceptionutils;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.MarshallerHelper;
import be.business.connector.projects.common.utils.ValidationUtils;
import be.business.connector.recipe.AbstractRecipeClient;
import be.business.connector.recipe.executor.AbstractExecutorIntegrationModuleV4;
import be.business.connector.recipe.executor.domain.GetPrescriptionForExecutorResult;
import be.business.connector.recipe.executor.dto.ListOpenPrescriptionsResultWithExceptions;
import be.business.connector.recipe.executor.dto.ListReservationsResultWithExceptions;
import be.business.connector.recipe.executor.services.RecipeExecutorServiceV4Impl;
import be.business.connector.recipe.utils.GetAndMarkAsDeliveredThread;
import be.business.connector.recipe.utils.RidValidator;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.fgov.ehealth.recipe.core.v4.SecuredContentType;
import be.fgov.ehealth.recipe.protocol.v4.CreateFeedbackRequest;
import be.fgov.ehealth.recipe.protocol.v4.CreateFeedbackResponse;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionForExecutorRequest;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionForExecutorResponse;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusRequest;
import be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusResponse;
import be.fgov.ehealth.recipe.protocol.v4.ListNotificationsRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListNotificationsResponse;
import be.fgov.ehealth.recipe.protocol.v4.ListOpenPrescriptionsRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListOpenPrescriptionsResponse;
import be.fgov.ehealth.recipe.protocol.v4.ListRelationsRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListRelationsResponse;
import be.fgov.ehealth.recipe.protocol.v4.ListReservationsRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListReservationsResponse;
import be.fgov.ehealth.recipe.protocol.v4.ListRidsHistoryRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListRidsHistoryResponse;
import be.fgov.ehealth.recipe.protocol.v4.ListRidsInProcessRequest;
import be.fgov.ehealth.recipe.protocol.v4.ListRidsInProcessResponse;
import be.fgov.ehealth.recipe.protocol.v4.MarkAsArchivedRequest;
import be.fgov.ehealth.recipe.protocol.v4.MarkAsArchivedResponse;
import be.fgov.ehealth.recipe.protocol.v4.MarkAsDeliveredRequest;
import be.fgov.ehealth.recipe.protocol.v4.MarkAsDeliveredResponse;
import be.fgov.ehealth.recipe.protocol.v4.MarkAsUnDeliveredRequest;
import be.fgov.ehealth.recipe.protocol.v4.MarkAsUnDeliveredResponse;
import be.fgov.ehealth.recipe.protocol.v4.PutRidsInProcessRequest;
import be.fgov.ehealth.recipe.protocol.v4.PutRidsInProcessResponse;
import be.fgov.ehealth.recipe.protocol.v4.RevokePrescriptionRequest;
import be.fgov.ehealth.recipe.protocol.v4.RevokePrescriptionResponse;
import be.recipe.services.core.MandateHolderType;
import be.recipe.services.core.ResponseType;
import be.recipe.services.executor.CreateFeedbackResult;
import be.recipe.services.executor.GetPrescriptionForExecutorResultSealed;
import be.recipe.services.executor.GetPrescriptionStatusParam;
import be.recipe.services.executor.GetPrescriptionStatusResult;
import be.recipe.services.executor.ListNotificationsItem;
import be.recipe.services.executor.ListNotificationsResult;
import be.recipe.services.executor.ListOpenPrescriptionsParam;
import be.recipe.services.executor.ListOpenPrescriptionsResult;
import be.recipe.services.executor.ListRelationsParam;
import be.recipe.services.executor.ListRelationsResult;
import be.recipe.services.executor.ListReservationsParam;
import be.recipe.services.executor.ListReservationsResult;
import be.recipe.services.executor.ListRidsHistoryParam;
import be.recipe.services.executor.ListRidsHistoryResult;
import be.recipe.services.executor.ListRidsInProcessParam;
import be.recipe.services.executor.ListRidsInProcessResult;
import be.recipe.services.executor.MarkAsArchivedResult;
import be.recipe.services.executor.MarkAsDeliveredResult;
import be.recipe.services.executor.MarkAsUndeliveredResult;
import be.recipe.services.executor.PutRidsInProcessParam;
import be.recipe.services.executor.PutRidsInProcessResult;
import be.recipe.services.executor.RevokePrescriptionResult;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java8.util.function.Function;
import java8.util.stream.Collectors;
import java8.util.stream.StreamSupport;
import javax.xml.ws.WebServiceException;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorIntegrationModuleV4Impl
extends AbstractExecutorIntegrationModuleV4 {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorIntegrationModuleV4Impl.class);
    private static final Map<MultiKey, byte[]> sessionMap = new HashMap<MultiKey, byte[]>();

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#getData(ListOpenPrescriptionsParam)")
    public ListOpenPrescriptionsResult getData(ListOpenPrescriptionsParam param) {
        long startListOpenPrescriptions = System.currentTimeMillis();
        ApplicationConfig.getInstance().assertValidPharmacySession();
        ValidationUtils.validatePatientId(param.getPatientId());
        ValidationUtils.validateMandateHolderId(param.getMandateHolderId(), true);
        ListOpenPrescriptionsRequest listOpenPrescriptionsRequest = this.getOpenPrescriptionList(param);
        try {
            try {
                ListOpenPrescriptionsResponse response = RecipeExecutorServiceV4Impl.getInstance().listOpenPrescriptions(listOpenPrescriptionsRequest);
                ListOpenPrescriptionsResult result = this.unsealGetDataResponse(response);
                this.checkStatus((ResponseType)result);
                sessionMap.put(new MultiKey((Object)StandaloneRequestorProvider.getRequestorIdInformation(), (Object)param.getPatientId()), result.getSession());
                long stopListOpenPrescriptions = System.currentTimeMillis();
                LOG.debug("List Open Prescriptions took {} ms", (Object)(stopListOpenPrescriptions - startListOpenPrescriptions));
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, listOpenPrescriptionsRequest.getId());
            return null;
        }
    }

    public ListOpenPrescriptionsResult unsealGetDataResponse(ListOpenPrescriptionsResponse response) {
        MarshallerHelper<ListOpenPrescriptionsResult, Object> marshaller = new MarshallerHelper<ListOpenPrescriptionsResult, Object>(ListOpenPrescriptionsResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getSecuredListOpenPrescriptionsResponse().getSecuredContent(), this.getSymmKey());
    }

    private ListOpenPrescriptionsRequest getOpenPrescriptionList(ListOpenPrescriptionsParam listOpenPrescriptionsParam) {
        listOpenPrescriptionsParam.setSession(sessionMap.get(new MultiKey((Object)StandaloneRequestorProvider.getRequestorIdInformation(), (Object)(StringUtils.isNotBlank((String)listOpenPrescriptionsParam.getMandateHolderId()) ? listOpenPrescriptionsParam.getMandateHolderId() : listOpenPrescriptionsParam.getPatientId()))));
        ListOpenPrescriptionsRequest request = new ListOpenPrescriptionsRequest();
        request.setSecuredListOpenPrescriptionsRequest(this.createSecuredContentType(this.getSealedData(listOpenPrescriptionsParam)));
        request.setIssueInstant(new DateTime());
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setId(this.getId());
        return request;
    }

    private GetPrescriptionStatusRequest getPrescriptionStatus(GetPrescriptionStatusParam getPrescriptionStatusParam) {
        GetPrescriptionStatusRequest request = new GetPrescriptionStatusRequest();
        request.setSecuredGetPrescriptionStatusRequest(this.createSecuredContentType(this.getSealedData(getPrescriptionStatusParam)));
        request.setIssueInstant(new DateTime());
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setId(this.getId());
        return request;
    }

    public byte[] getSealedData(ListOpenPrescriptionsParam listOpenPrescriptionsParam) {
        listOpenPrescriptionsParam.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(listOpenPrescriptionsParam, ListOpenPrescriptionsParam.class);
    }

    public SecuredContentType createSecuredContentType(byte[] content) {
        SecuredContentType secured = new SecuredContentType();
        secured.setSecuredContent(content);
        return secured;
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#getData(GetPrescriptionStatusParam)")
    public GetPrescriptionStatusResult getData(GetPrescriptionStatusParam param) {
        RidValidator.validateRid(param.getRid());
        ApplicationConfig.getInstance().assertValidPharmacySession();
        GetPrescriptionStatusRequest getPrescriptionStatus = this.getPrescriptionStatus(param);
        try {
            try {
                GetPrescriptionStatusResponse response = RecipeExecutorServiceV4Impl.getInstance().getPrescriptionStatus(getPrescriptionStatus);
                GetPrescriptionStatusResult result = this.unsealGetPrescriptionStatusResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, getPrescriptionStatus.getId());
            return null;
        }
    }

    public GetPrescriptionStatusResult unsealGetPrescriptionStatusResponse(GetPrescriptionStatusResponse response) {
        MarshallerHelper<GetPrescriptionStatusResult, Object> marshaller = new MarshallerHelper<GetPrescriptionStatusResult, Object>(GetPrescriptionStatusResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getSecuredGetPrescriptionStatusResponse().getSecuredContent(), this.getSymmKey());
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#getData(ListRidsHistoryParam)")
    public ListRidsHistoryResult getData(ListRidsHistoryParam param) {
        ApplicationConfig.getInstance().assertValidPharmacySession();
        ValidationUtils.validatePatientId(param.getPatientId());
        ListRidsHistoryRequest listPrescriptionHistory = this.getListRidsHistory(param);
        try {
            try {
                ListRidsHistoryResponse response = RecipeExecutorServiceV4Impl.getInstance().listRidsHistory(listPrescriptionHistory);
                ListRidsHistoryResult result = this.unsealListRidsHistoryResponse(response);
                this.checkStatus((ResponseType)result);
                sessionMap.put(new MultiKey((Object)StandaloneRequestorProvider.getRequestorIdInformation(), (Object)param.getPatientId()), result.getSession());
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, listPrescriptionHistory.getId());
            return null;
        }
    }

    private ListRidsHistoryRequest getListRidsHistory(ListRidsHistoryParam listRidsHistoryParam) {
        listRidsHistoryParam.setSession(sessionMap.get(new MultiKey((Object)StandaloneRequestorProvider.getRequestorIdInformation(), (Object)listRidsHistoryParam.getPatientId())));
        ListRidsHistoryRequest request = new ListRidsHistoryRequest();
        request.setSecuredListRidsHistoryRequest(this.createSecuredContentType(this.getSealedData(listRidsHistoryParam)));
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setIssueInstant(new DateTime());
        request.setId(this.getId());
        return request;
    }

    private byte[] getSealedData(ListRidsHistoryParam listRidsHistoryParam) {
        listRidsHistoryParam.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(listRidsHistoryParam, ListRidsHistoryParam.class);
    }

    private ListRidsHistoryResult unsealListRidsHistoryResponse(ListRidsHistoryResponse response) {
        MarshallerHelper<ListRidsHistoryResult, Object> marshaller = new MarshallerHelper<ListRidsHistoryResult, Object>(ListRidsHistoryResult.class, Object.class);
        return marshaller.unsealWithSymmKey(response.getSecuredListRidsHistoryResponse().getSecuredContent(), this.getSymmKey());
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="ExecutorIntegrationModuleV4#getPrescription")
    public GetPrescriptionForExecutorResult getPrescription(String rid) {
        return this.getPrescription(rid, null, null, false);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="ExecutorIntegrationModuleV4#getPrescription")
    public GetPrescriptionForExecutorResult getPrescription(String rid, boolean skipInProcess) {
        return this.getPrescription(rid, null, null, skipInProcess);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="ExecutorIntegrationModuleV4#getPrescription")
    public GetPrescriptionForExecutorResult getPrescription(String rid, String mandateHolderId, MandateHolderType mandateHolderType) {
        return this.getPrescription(rid, null, null, false);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="ExecutorIntegrationModule#getPrescription")
    public GetPrescriptionForExecutorResult getPrescription(String rid, String mandateHolderId, MandateHolderType mandateHolderType, boolean skipInProcess) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidPharmacySession();
        String guid = this.getId();
        try {
            byte[] sealedGetPrescriptionForExecutorParam = this.getSealedGetPrescriptionForExecutorParam(rid, null, mandateHolderId, mandateHolderType, skipInProcess);
            GetPrescriptionForExecutorRequest request = new GetPrescriptionForExecutorRequest();
            request.setDisablePatientInsurabilityCheckParam(Boolean.parseBoolean(this.getPropertyHandler().getProperty("patient.insurability.disable", "true")));
            request.setSecuredGetPrescriptionForExecutorRequest(this.createSecuredContentType(sealedGetPrescriptionForExecutorParam));
            request.setIssueInstant(new DateTime());
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setId(guid);
            GetPrescriptionForExecutorResponse response = null;
            try {
                response = RecipeExecutorServiceV4Impl.getInstance().getPrescriptionForExecutor(request);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
            byte[] securedContent = response.getSecuredGetPrescriptionForExecutorResponse().getSecuredContent();
            GetPrescriptionForExecutorResult finalResult = this.createGetPrescriptionForExecutorResult(securedContent);
            this.checkStatus((ResponseType)finalResult);
            ExecutorIntegrationModuleV4Impl.getPrescriptionCache().put(rid, finalResult);
            return finalResult;
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, guid);
            return null;
        }
    }

    protected GetPrescriptionForExecutorResult createGetPrescriptionForExecutorResult(byte[] securedContent) {
        MarshallerHelper<GetPrescriptionForExecutorResultSealed, Object> marshaller = new MarshallerHelper<GetPrescriptionForExecutorResultSealed, Object>(GetPrescriptionForExecutorResultSealed.class, Object.class);
        String requestorIdInformation = StandaloneRequestorProvider.getRequestorIdInformation();
        String requestorTypeInformation = StandaloneRequestorProvider.getRequestorTypeInformation();
        GetPrescriptionForExecutorResultSealed sealedResult = marshaller.unsealWithSymmKey(securedContent, this.getSymmKey());
        GetPrescriptionForExecutorResult finalResult = new GetPrescriptionForExecutorResult(sealedResult);
        finalResult.setStatus(sealedResult.getStatus());
        this.checkStatus((ResponseType)finalResult);
        finalResult.setSealedContent(sealedResult.getPrescription());
        KeyResult key = this.getKeyFromKgss(sealedResult.getEncryptionKeyId(), this.getEtkHelper().getEtks(KgssIdentifierType.NIHII_PHARMACY, requestorIdInformation).get(0).getEncoded());
        byte[] unsealedPrescription = this.unsealWithSymKey(sealedResult, key, requestorIdInformation, requestorTypeInformation);
        finalResult.setPrescription(unsealedPrescription);
        finalResult.setEncryptionKey(key.getSecretKey().getEncoded());
        return finalResult;
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#markAsArchived")
    public void markAsArchived(String rid) {
        this.markAsArchived(rid, null, null);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#markAsArchived")
    public void markAsArchived(String rid, String mandateHolderId, MandateHolderType mandateHolderType) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidPharmacySession();
        MarkAsArchivedRequest request = new MarkAsArchivedRequest();
        try {
            byte[] sealedMarkAsArchivedParam = this.getSealedMarkAsArchivedParam(rid, mandateHolderId, mandateHolderType);
            request.setSecuredMarkAsArchivedRequest(this.createSecuredContentType(sealedMarkAsArchivedParam));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setIssueInstant(new DateTime());
            request.setId(this.getId());
            try {
                MarkAsArchivedResponse response = RecipeExecutorServiceV4Impl.getInstance().markAsArchived(request);
                MarshallerHelper<MarkAsArchivedResult, Object> marshaller = new MarshallerHelper<MarkAsArchivedResult, Object>(MarkAsArchivedResult.class, Object.class);
                MarkAsArchivedResult result = marshaller.unsealWithSymmKey(response.getSecuredMarkAsArchivedResponse().getSecuredContent(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getId());
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#markAsDelivered")
    public void markAsDelivered(String rid) {
        this.markAsDelivered(rid, null, null);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#markAsDelivered")
    public void markAsDelivered(String rid, String mandateHolderId, MandateHolderType mandateHolderType) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidPharmacySession();
        MarkAsDeliveredRequest request = new MarkAsDeliveredRequest();
        try {
            byte[] sealedMarkAsDeliveredParam = this.getSealedMarkAsDeliveredParam(rid, mandateHolderId, mandateHolderType);
            request.setSecuredMarkAsDeliveredRequest(this.createSecuredContentType(sealedMarkAsDeliveredParam));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setIssueInstant(new DateTime());
            request.setId(this.getId());
            MarkAsDeliveredResponse response = null;
            try {
                response = RecipeExecutorServiceV4Impl.getInstance().markAsDelivered(request);
                MarshallerHelper<MarkAsDeliveredResult, Object> marshaller = new MarshallerHelper<MarkAsDeliveredResult, Object>(MarkAsDeliveredResult.class, Object.class);
                MarkAsDeliveredResult result = marshaller.unsealWithSymmKey(response.getSecuredMarkAsDeliveredResponse().getSecuredContent(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getId());
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#markAsUnDelivered")
    public void markAsUndelivered(String rid) {
        this.markAsUndelivered(rid, null, null);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#markAsUnDelivered")
    public void markAsUndelivered(String rid, String mandateHolderId, MandateHolderType mandateHolderType) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidPharmacySession();
        MarkAsUnDeliveredRequest request = new MarkAsUnDeliveredRequest();
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setId(this.getId());
        try {
            byte[] sealedMarkAsUnDeliveredParam = this.getSealedMarkAsUnDeliveredParam(rid, mandateHolderId, mandateHolderType);
            request.setSecuredMarkAsUnDeliveredRequest(this.createSecuredContentType(sealedMarkAsUnDeliveredParam));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setIssueInstant(new DateTime());
            request.setId(this.getId());
            MarkAsUnDeliveredResponse response = null;
            try {
                response = RecipeExecutorServiceV4Impl.getInstance().markAsUnDelivered(request);
                MarshallerHelper<MarkAsUndeliveredResult, Object> marshaller = new MarshallerHelper<MarkAsUndeliveredResult, Object>(MarkAsUndeliveredResult.class, Object.class);
                MarkAsUndeliveredResult result = marshaller.unsealWithSymmKey(response.getSecuredMarkAsUnDeliveredResponse().getSecuredContent(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
                if (ExecutorIntegrationModuleV4Impl.getPrescriptionCache().containsKey(rid)) {
                    ExecutorIntegrationModuleV4Impl.getPrescriptionCache().remove(rid);
                }
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getId());
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#revokePrescription")
    public void revokePrescription(String rid, String reason) {
        this.revokePrescription(rid, reason, null, null);
    }

    @Override
    public void revokePrescription(String rid, String reason, String mandateHolderId, MandateHolderType mandateHolderType) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidPharmacySession();
        RevokePrescriptionRequest request = new RevokePrescriptionRequest();
        try {
            byte[] sealedRevokePrescriptionParam = this.getSealedRevokePrescriptionParam(rid, reason, mandateHolderId, mandateHolderType);
            request.setSecuredRevokePrescriptionRequest(this.createSecuredContentType(sealedRevokePrescriptionParam));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setIssueInstant(new DateTime());
            request.setId(this.getId());
            RevokePrescriptionResponse response = null;
            try {
                response = RecipeExecutorServiceV4Impl.getInstance().revokePrescriptionForExecutor(request);
                MarshallerHelper<RevokePrescriptionResult, Object> marshaller = new MarshallerHelper<RevokePrescriptionResult, Object>(RevokePrescriptionResult.class, Object.class);
                RevokePrescriptionResult result = marshaller.unsealWithSymmKey(response.getSecuredRevokePrescriptionResponse().getSecuredContent(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getId());
        }
    }

    @Override
    public List<ListNotificationsItem> listNotifications(boolean readFlag) {
        return this.listNotifications(readFlag, null, null);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#listNotifications")
    public List<ListNotificationsItem> listNotifications(boolean readFlag, String mandateHolderId, MandateHolderType mandateHolderType) {
        ApplicationConfig.getInstance().assertValidPharmacySession();
        ListNotificationsRequest request = new ListNotificationsRequest();
        try {
            byte[] sealedListNotificationsParam = this.getSealedListNotificationsParam(readFlag, mandateHolderId, mandateHolderType);
            request.setSecuredListNotificationsRequest(this.createSecuredContentType(sealedListNotificationsParam));
            request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
            request.setIssueInstant(new DateTime());
            request.setId(this.getId());
            ListNotificationsResponse response = null;
            try {
                response = RecipeExecutorServiceV4Impl.getInstance().listNotifications(request);
                MarshallerHelper<ListNotificationsResult, Object> marshaller = new MarshallerHelper<ListNotificationsResult, Object>(ListNotificationsResult.class, Object.class);
                ListNotificationsResult result = marshaller.unsealWithSymmKey(response.getSecuredListNotificationsResponse().getSecuredContent(), this.getSymmKey());
                this.checkStatus((ResponseType)result);
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
            byte[] securedContent = response.getSecuredListNotificationsResponse().getSecuredContent();
            return this.createListNotificationItems(securedContent);
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getId());
            return null;
        }
    }

    @Override
    public void createFeedback(String prescriberId, String rid, byte[] feedbackText) {
        this.createFeedback(prescriberId, rid, feedbackText, null, null);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#createFeedback")
    public void createFeedback(String prescriberId, String rid, byte[] feedbackText, String mandateHolderId, MandateHolderType mandateHolderType) {
        RidValidator.validateRid(rid);
        ApplicationConfig.getInstance().assertValidPharmacySession();
        CreateFeedbackRequest request = new CreateFeedbackRequest();
        try {
            this.getKmehrHelper().assertValidFeedback(feedbackText);
            ArrayList<EncryptionToken> etkRecipients = new ArrayList<EncryptionToken>();
            try {
                etkRecipients.addAll(this.getEtkHelper().getEtks(KgssIdentifierType.NIHII, prescriberId));
            }
            catch (Exception e) {
                try {
                    etkRecipients.addAll(this.getEtkHelper().getEtks(KgssIdentifierType.NIHII_PHARMACY, prescriberId));
                }
                catch (Exception e1) {
                    try {
                        etkRecipients.addAll(this.getEtkHelper().getEtks(KgssIdentifierType.NIHII_HOSPITAL, prescriberId));
                    }
                    catch (Exception e2) {
                        Exceptionutils.errorHandler(e1, e.getMessage() + e2.getMessage());
                    }
                }
            }
            for (int i = 0; i < etkRecipients.size(); ++i) {
                EncryptionToken etkRecipient = (EncryptionToken)etkRecipients.get(i);
                byte[] sealedCreateFeedbackParam = this.getSealedCreateFeedbackParam(feedbackText, etkRecipient, rid, prescriberId, mandateHolderId, mandateHolderType);
                request.setSecuredCreateFeedbackRequest(this.createSecuredContentType(sealedCreateFeedbackParam));
                request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
                request.setIssueInstant(new DateTime());
                request.setId(this.getId());
                try {
                    CreateFeedbackResponse response = RecipeExecutorServiceV4Impl.getInstance().createFeedback(request);
                    CreateFeedbackResult result = this.unsealCreateFeedbackResponse(response);
                    this.checkStatus((ResponseType)result);
                    continue;
                }
                catch (WebServiceException cte) {
                    throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
                }
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getId());
        }
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#getData(ListReservationsParam)")
    public ListReservationsResult getData(ListReservationsParam param) {
        ApplicationConfig.getInstance().assertValidPharmacySession();
        Calendar lastSyncDate = Calendar.getInstance();
        try {
            ListReservationsRequest request = this.getListReservations(param);
            ListReservationsResponse response = RecipeExecutorServiceV4Impl.getInstance().listReservations(request);
            ListReservationsResult result = this.unsealListReservationsResponse(response);
            this.checkStatus((ResponseType)result);
            this.writeReservationsOnDisk(param, result, lastSyncDate);
            return result;
        }
        catch (WebServiceException cte) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    protected ListReservationsRequest getListReservations(ListReservationsParam param) {
        param.setSymmKey(this.getSymmKey().getEncoded());
        param.setStartDate(param.getStartDate() == null ? this.readLastDateToDisk() : param.getStartDate());
        ListReservationsRequest request = new ListReservationsRequest();
        request.setSecuredListReservationsRequest(this.createSecuredContentType(this.getSealedData(param)));
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setIssueInstant(new DateTime());
        request.setId(this.getId());
        return request;
    }

    private byte[] getSealedData(ListReservationsParam listReservationsParam) {
        listReservationsParam.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(listReservationsParam, ListReservationsParam.class);
    }

    private ListReservationsResult unsealListReservationsResponse(ListReservationsResponse response) {
        MarshallerHelper<ListReservationsResult, Object> marshaller = new MarshallerHelper<ListReservationsResult, Object>(ListReservationsResult.class, Object.class);
        ListReservationsResult result = marshaller.unsealWithSymmKey(response.getSecuredListReservationsResponse().getSecuredContent(), this.getSymmKey());
        return result;
    }

    private CreateFeedbackResult unsealCreateFeedbackResponse(CreateFeedbackResponse response) {
        MarshallerHelper<CreateFeedbackResult, Object> marshaller = new MarshallerHelper<CreateFeedbackResult, Object>(CreateFeedbackResult.class, Object.class);
        CreateFeedbackResult result = marshaller.unsealWithSymmKey(response.getSecuredCreateFeedbackResponse().getSecuredContent(), this.getSymmKey());
        return result;
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#getData(ListRidsInProcessParam)")
    public ListRidsInProcessResult getData(ListRidsInProcessParam param) {
        ApplicationConfig.getInstance().assertValidPharmacySession();
        try {
            ListRidsInProcessRequest request = this.getListRidsInProcess(param);
            try {
                ListRidsInProcessResponse response = RecipeExecutorServiceV4Impl.getInstance().listRidsInProcess(request);
                ListRidsInProcessResult result = this.unsealListRidsInProcessResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    private ListRidsInProcessRequest getListRidsInProcess(ListRidsInProcessParam listRidsInProcessParam) {
        listRidsInProcessParam.setSymmKey(this.getSymmKey().getEncoded());
        ListRidsInProcessRequest request = new ListRidsInProcessRequest();
        request.setSecuredListRidsInProcessRequest(this.createSecuredContentType(this.getSealedData(listRidsInProcessParam)));
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setIssueInstant(new DateTime());
        request.setId(this.getId());
        return request;
    }

    private byte[] getSealedData(ListRidsInProcessParam listRidsInProcessParam) {
        return this.sealForRecipe(listRidsInProcessParam, ListRidsInProcessParam.class);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#putData(PutAllRidInProcessParam)")
    public PutRidsInProcessResult putData(PutRidsInProcessParam param) {
        ApplicationConfig.getInstance().assertValidPharmacySession();
        PutRidsInProcessRequest request = this.getPutAllRidInProcess(param);
        try {
            try {
                PutRidsInProcessResponse response = RecipeExecutorServiceV4Impl.getInstance().putRidsInProcess(request);
                PutRidsInProcessResult result = this.unsealPutRidsInProcessResponse(response);
                this.checkStatus((ResponseType)result);
                return result;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t, request.getId());
            return null;
        }
    }

    public PutRidsInProcessRequest getPutAllRidInProcess(PutRidsInProcessParam putRidsInProcessParam) {
        putRidsInProcessParam.setSymmKey(this.getSymmKey().getEncoded());
        PutRidsInProcessRequest request = new PutRidsInProcessRequest();
        request.setSecuredPutRidsInProcessRequest(this.createSecuredContentType(this.getSealedData(putRidsInProcessParam)));
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setId(this.getId());
        request.setIssueInstant(new DateTime());
        return request;
    }

    private byte[] getSealedData(PutRidsInProcessParam putRidsInProcessParam) {
        putRidsInProcessParam.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(putRidsInProcessParam, PutRidsInProcessParam.class);
    }

    private PutRidsInProcessResult unsealPutRidsInProcessResponse(PutRidsInProcessResponse response) {
        MarshallerHelper<PutRidsInProcessResult, Object> marshaller = new MarshallerHelper<PutRidsInProcessResult, Object>(PutRidsInProcessResult.class, Object.class);
        PutRidsInProcessResult result = marshaller.unsealWithSymmKey(response.getSecuredPutRidsInProcessResponse().getSecuredContent(), this.getSymmKey());
        return result;
    }

    private ListRidsInProcessResult unsealListRidsInProcessResponse(ListRidsInProcessResponse response) {
        MarshallerHelper<ListRidsInProcessResult, Object> marshaller = new MarshallerHelper<ListRidsInProcessResult, Object>(ListRidsInProcessResult.class, Object.class);
        ListRidsInProcessResult result = marshaller.unsealWithSymmKey(response.getSecuredListRidsInProcessResponse().getSecuredContent(), this.getSymmKey());
        return result;
    }

    @Override
    public GetPrescriptionForExecutorResult getAndMarkAsDelivered(String rid) {
        return this.getAndMarkAsDelivered(rid, null, null);
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#getAndMarkAsDelivered")
    public GetPrescriptionForExecutorResult getAndMarkAsDelivered(String rid, String mandateHolderId, MandateHolderType mandateHolderType) {
        try {
            GetPrescriptionForExecutorResult getPrescriptionForExecutorResult = ExecutorIntegrationModuleV4Impl.getPrescriptionCache().containsKey(rid) ? ExecutorIntegrationModuleV4Impl.getPrescriptionCache().get(rid) : this.getPrescription(rid, mandateHolderId, mandateHolderType);
            this.markAsDelivered(rid, mandateHolderId, mandateHolderType);
            return getPrescriptionForExecutorResult;
        }
        catch (Exception t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    @Override
    public List<GetPrescriptionForExecutorResult> getAndMarkAsDelivered(List<String> rids) {
        List threads = (List)StreamSupport.stream(rids).map((Function)new Function<String, GetAndMarkAsDeliveredThread>(){

            public GetAndMarkAsDeliveredThread apply(String rid) {
                return new GetAndMarkAsDeliveredThread(rid, ExecutorIntegrationModuleV4Impl.this);
            }
        }).collect(Collectors.toList());
        for (GetAndMarkAsDeliveredThread thread : threads) {
            thread.run();
        }
        return (List)StreamSupport.stream((Collection)threads).map((Function)new Function<GetAndMarkAsDeliveredThread, GetPrescriptionForExecutorResult>(){

            public GetPrescriptionForExecutorResult apply(GetAndMarkAsDeliveredThread thread) {
                return thread.getResult();
            }
        }).collect(Collectors.toList());
    }

    @Override
    @Profiled(logFailuresSeparately=true, tag="0.ExecutorIntegrationModuleV4#getData(ListRelationsParam)")
    @Deprecated
    public ListRelationsResult getData(ListRelationsParam patientRelationParam) {
        ApplicationConfig.getInstance().assertValidPharmacySession();
        ValidationUtils.validatePatientId(patientRelationParam.getMandateHolderId());
        try {
            ListRelationsRequest request = this.getListPatientRelation(patientRelationParam);
            try {
                ListRelationsResponse dataResponse = RecipeExecutorServiceV4Impl.getInstance().listRelations(request);
                ListRelationsResult unsealedResponse = this.unsealListRelationsResponse(dataResponse);
                this.checkStatus((ResponseType)unsealedResponse);
                sessionMap.put(new MultiKey((Object)StandaloneRequestorProvider.getRequestorIdInformation(), (Object)patientRelationParam.getMandateHolderId()), unsealedResponse.getSession());
                return unsealedResponse;
            }
            catch (WebServiceException cte) {
                throw new IntegrationModuleException(I18nHelper.getLabel("error.connection.executor"), cte);
            }
        }
        catch (Throwable t) {
            Exceptionutils.errorHandler(t);
            return null;
        }
    }

    private ListRelationsRequest getListPatientRelation(ListRelationsParam data) {
        data.setSymmKey(this.getSymmKey().getEncoded());
        data.setSession(sessionMap.get(new MultiKey((Object)StandaloneRequestorProvider.getRequestorIdInformation(), (Object)data.getMandateHolderId())));
        ListRelationsRequest request = new ListRelationsRequest();
        request.setSecuredListRelationsRequest(this.createSecuredContentType(this.getSealedData(data)));
        request.setIssueInstant(new DateTime());
        request.setProgramId(AbstractRecipeClient.programId(this.getClass().getSimpleName()));
        request.setId(this.getId());
        return request;
    }

    private byte[] getSealedData(ListRelationsParam data) {
        data.setSymmKey(this.getSymmKey().getEncoded());
        return this.sealForRecipe(data, ListRelationsParam.class);
    }

    private ListRelationsResult unsealListRelationsResponse(ListRelationsResponse response) {
        MarshallerHelper<ListRelationsResult, Object> marshaller = new MarshallerHelper<ListRelationsResult, Object>(ListRelationsResult.class, Object.class);
        ListRelationsResult result = marshaller.unsealWithSymmKey(response.getSecuredListRelationsResponse().getSecuredContent(), this.getSymmKey());
        return result;
    }

    @Override
    public void clearSession() {
        sessionMap.clear();
    }

    @Override
    public ListReservationsResult listReservationsDecrypted(ListReservationsParam request) {
        return this.decryptListReservationsResult(this.getData(request));
    }

    @Override
    public ListReservationsResultWithExceptions listReservationsDecryptedWithExceptions(ListReservationsParam request) {
        return this.decryptListReservationsResultWithExceptions(this.getData(request));
    }

    @Override
    public ListOpenPrescriptionsResult listOpenPrescriptionsDecrypted(ListOpenPrescriptionsParam request) {
        long startList = System.currentTimeMillis();
        ListOpenPrescriptionsResult listOpenPRescriptionsResult = this.getData(request);
        long stopList = System.currentTimeMillis();
        long startDecrypt = System.currentTimeMillis();
        ListOpenPrescriptionsResult listOpenPrescriptionsResult = this.decryptListOpenPrescriptionsResult(listOpenPRescriptionsResult);
        long stopDecrypt = System.currentTimeMillis();
        LOG.debug("List Open Prescriptions took {} ms", (Object)(stopList - startList));
        LOG.debug("Decrypting List Open Prescriptions took {} ms", (Object)(stopDecrypt - startDecrypt));
        LOG.debug("Total List + Decrypt Open Prescriptions took {} ms", (Object)(stopDecrypt - startList));
        return listOpenPrescriptionsResult;
    }

    @Override
    public ListOpenPrescriptionsResult listOpenPrescriptionsDecryptedSingleThreaded(ListOpenPrescriptionsParam request) {
        long startList = System.currentTimeMillis();
        ListOpenPrescriptionsResult listOpenPRescriptionsResult = this.getData(request);
        long stopList = System.currentTimeMillis();
        long startDecrypt = System.currentTimeMillis();
        ListOpenPrescriptionsResult listOpenPrescriptionsResult = this.decryptListOpenPrescriptionsResultSingleThreaded(listOpenPRescriptionsResult);
        long stopDecrypt = System.currentTimeMillis();
        LOG.debug("List Open Prescriptions took {} ms", (Object)(stopList - startList));
        LOG.debug("Decrypting List Open Prescriptions took {} ms", (Object)(stopDecrypt - startDecrypt));
        LOG.debug("Total List + Decrypt Open Prescriptions took {} ms", (Object)(stopDecrypt - startList));
        return listOpenPrescriptionsResult;
    }

    @Override
    public ListOpenPrescriptionsResultWithExceptions listOpenPrescriptionsWithExceptionsDecrypted(ListOpenPrescriptionsParam request) {
        long startList = System.currentTimeMillis();
        ListOpenPrescriptionsResultWithExceptions listOpenPrescriptionsResultWithExceptions = this.decryptListOpenPrescriptionsResultWithExceptions(this.getData(request));
        long stopList = System.currentTimeMillis();
        LOG.debug("List and decrypt open prescriptions with exceptions took {} ms", (Object)(stopList - startList));
        return listOpenPrescriptionsResultWithExceptions;
    }
}

