/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.utils;

import be.business.connector.core.utils.OnlineProperties;
import be.business.connector.core.utils.PropertyHandler;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlinePropertiesHolder {
    private static final Logger LOG = LoggerFactory.getLogger(OnlinePropertiesHolder.class);
    private static OnlineProperties onlineProperties;
    private static boolean isXsdSet;
    private static PropertyHandler propertyHandler;

    private OnlinePropertiesHolder() {
    }

    public static OnlineProperties getInstance() {
        if (onlineProperties == null) {
            onlineProperties = new OnlineProperties();
        }
        return onlineProperties;
    }

    public static void reloadProperties() {
        if (onlineProperties != null) {
            Properties properties = OnlinePropertiesHolder.getPropertyHandler().getProperties();
            if (onlineProperties.getProperties() != null && !onlineProperties.getProperties().isEmpty()) {
                properties.putAll(onlineProperties.getProperties());
            }
            OnlinePropertiesHolder.log("After Reloading online properties: ", onlineProperties.getProperties());
            OnlinePropertiesHolder.log("After Reloading online system properties: ", properties);
            OnlinePropertiesHolder.getPropertyHandler().setProperties(properties);
            OnlinePropertiesHolder.log("After setting the system properties: ", OnlinePropertiesHolder.getPropertyHandler().getProperties());
        }
    }

    public static PropertyHandler getPropertyHandler() {
        if (propertyHandler == null) {
            propertyHandler = PropertyHandler.getInstance();
        }
        return propertyHandler;
    }

    private static void log(String message, Map<String, String> properties) {
        LOG.debug("**************************************************");
        LOG.debug("***********" + message + "**********");
        LOG.debug("**************************************************");
        if (properties != null && !properties.keySet().isEmpty()) {
            for (String clientKey : properties.keySet()) {
                LOG.debug(clientKey + " " + properties.get(clientKey));
            }
        }
    }

    private static void log(String message, Properties properties) {
        LOG.debug("**************************************************");
        LOG.debug("***********" + message + "**********");
        LOG.debug("**************************************************");
        for (String clientKey : properties.stringPropertyNames()) {
            LOG.debug(clientKey + " " + properties.getProperty(clientKey));
        }
    }

    public static boolean isXsdSet() {
        return isXsdSet;
    }

    public static void setXsdSet(boolean isXsdSet) {
        OnlinePropertiesHolder.isXsdSet = isXsdSet;
    }

    static {
        isXsdSet = false;
    }
}

