/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.utils;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.NamespaceContext;

public class MapNamespaceContext
implements NamespaceContext {
    private Map<String, String> nsMappings = new TreeMap<String, String>();

    public MapNamespaceContext() {
        this.nsMappings.put("", "http://www.ehealth.fgov.be/standards/kmehr/schema/v1");
        this.nsMappings.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.nsMappings.put("xmlns", "http://www.w3.org/2000/xmlns/");
    }

    public MapNamespaceContext(String ... namespaceArray) {
        this();
        for (int i = 0; i < namespaceArray.length; ++i) {
            this.getNsMappings().put("ns" + Integer.toString(i + 1), namespaceArray[i]);
        }
    }

    public MapNamespaceContext(Map<String, String> namespaceMap) {
        this();
        this.nsMappings = namespaceMap;
    }

    protected final Map<String, String> getNsMappings() {
        return this.nsMappings;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix must be provided");
        }
        return this.nsMappings.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI must be provided");
        }
        for (Map.Entry<String, String> entity : this.nsMappings.entrySet()) {
            if (!entity.getValue().equals(namespaceURI)) continue;
            return entity.getKey();
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI must be provided");
        }
        LinkedList<String> prefixes = new LinkedList<String>();
        for (Map.Entry<String, String> entity : this.nsMappings.entrySet()) {
            if (!entity.getValue().equals(namespaceURI)) continue;
            prefixes.add(entity.getKey());
        }
        return prefixes.iterator();
    }
}

