/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.utils;

import be.business.connector.core.utils.CertificateExtension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtils.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;

    public static byte[] getBytes(InputStream inputStream) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) >= 0) {
                baos.write(buffer, 0, len);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] toByte(String string) {
        return string.getBytes();
    }

    public static byte[] loadResource(String path) {
        try {
            return IOUtils.getBytes(IOUtils.getResourceAsStream(path));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Profiled(logFailuresSeparately=true, tag="0.IOUtils#compress", logger="org.perf4j.TimingLogger_Common")
    public static byte[] compress(byte[] input) throws IOException {
        long size = input.length;
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        GZIPOutputStream out = new GZIPOutputStream(outstream);
        out.write(input);
        out.flush();
        outstream.flush();
        out.close();
        outstream.close();
        byte[] ret = outstream.toByteArray();
        LOG.debug("Compression of data from " + size + " bytes to " + ret.length + " bytes");
        return ret;
    }

    public static byte[] decompress(byte[] unSealmessage) throws IOException {
        int i;
        long size = unSealmessage.length;
        ByteArrayInputStream inputstream = new ByteArrayInputStream(unSealmessage);
        GZIPInputStream input = new GZIPInputStream(inputstream);
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((i = input.read(buffer)) > 0) {
            o.write(buffer, 0, i);
        }
        o.flush();
        input.close();
        inputstream.close();
        o.close();
        byte[] ret = o.toByteArray();
        LOG.debug("Decompression of data from " + size + " bytes to " + ret.length + " bytes");
        return ret;
    }

    public static InputStream getResourceAsStream(String path) throws IOException {
        URL u;
        InputStream stream;
        boolean skipLogging = true;
        File f = new File(path);
        if (!skipLogging) {
            LOG.info("Loading " + f.getAbsolutePath() + " from file system");
        }
        if (f.exists()) {
            if (!skipLogging) {
                LOG.info("Loading " + f.getAbsolutePath() + " from file system");
            }
            return new FileInputStream(f);
        }
        if (!skipLogging) {
            LOG.info("Loading " + path + " from classpath");
        }
        if ((stream = IOUtils.class.getResourceAsStream(path)) == null && (stream = (u = new URL(path = path.replace(" ", "%20"))).openStream()) == null) {
            throw new IOException("Invalid resource " + path);
        }
        return stream;
    }

    public static String getEnvironment() throws IOException {
        String env = System.getProperty("env");
        if (StringUtils.isNotBlank((CharSequence)env)) {
            return env;
        }
        Properties envProperties = new Properties();
        envProperties.load(IOUtils.getResourceAsStream("/env.properties"));
        return envProperties.getProperty("env");
    }

    public static String getFileAsFullPath(String path) throws IOException {
        File f = new File(path);
        if (f.exists()) {
            LOG.info("Loading " + path + " from file system");
            return f.getAbsolutePath();
        }
        return null;
    }

    public static String strConvert(byte[] message) {
        return message != null ? new String(message) : "";
    }

    public static List<String> getP12FileList(String path, String ssinRiziv) {
        if (path == null) {
            return Collections.emptyList();
        }
        ArrayList<String> fileList = new ArrayList<String>();
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            LOG.error("The directory " + path + " does not exist");
            return Collections.emptyList();
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        };
        File[] files = dir.listFiles(filter);
        String olddate = null;
        String filenames = null;
        if (files == null) {
            return Collections.emptyList();
        }
        for (File f : files) {
            LOG.info("Keystore filename: " + f.getName());
            if (!f.getName().contains(ssinRiziv) || !CertificateExtension.isSupported(f)) continue;
            try {
                CertificateExtension certificateExtension = CertificateExtension.lookupType(f);
                filenames = certificateExtension.removeExtension(f.getName());
                String[] filename = null;
                filename = f.getName().contains(" ") ? filenames.split(" ") : filenames.split("_");
                for (int i = 0; i < filename.length; ++i) {
                    LOG.info("Keystore filename part " + i + ":" + filename[i]);
                }
                String[] date = filename[filename.length - 1].split("-");
                for (int i = 0; i < date.length; ++i) {
                    LOG.info("Keystore date part " + i + ":" + date[i]);
                }
                LOG.info("Keystore date.length: " + date.length);
                LOG.info("Keystore date last part: " + date[date.length - 1]);
                String lastDt = date[date.length - 1];
                lastDt = lastDt.substring(0, 6);
                LOG.info("Keystore lastDt: " + lastDt);
                long newDate = Long.parseLong(date[0] + lastDt);
                LOG.info("Keystore new date:" + newDate);
                if (olddate != null && newDate > Long.parseLong(olddate)) {
                    if (fileList.size() > 0) {
                        fileList.remove(0);
                    }
                    fileList.add(f.getCanonicalPath());
                    olddate = String.valueOf(newDate);
                    continue;
                }
                if (olddate == null) {
                    fileList.add(f.getCanonicalPath());
                    olddate = String.valueOf(newDate);
                    continue;
                }
                fileList.add(f.getCanonicalPath());
            }
            catch (IOException e) {
                LOG.error("IOException on getP12FileList()", (Throwable)e);
            }
        }
        return fileList;
    }

    public static List<String> getConfigurationFileList(String path, String configName) {
        if (path == null) {
            return Collections.emptyList();
        }
        ArrayList<String> fileList = new ArrayList<String>();
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            LOG.error("The directory " + path + " does not exist");
            return Collections.emptyList();
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        };
        File[] files = dir.listFiles(filter);
        String filenames = null;
        Integer oldTot = 0;
        if (files == null) {
            return Collections.emptyList();
        }
        for (File f : files) {
            LOG.info("filename: " + f.getName());
            if (!f.getName().contains(configName) || !f.getName().endsWith(".xml")) continue;
            filenames = f.getName();
            String[] filename = null;
            filename = filenames.split("_");
            String version = null;
            for (int i = 0; i < filename.length; ++i) {
                Integer tot;
                String fi;
                LOG.info("Config filename part " + i + ":" + filename[i]);
                if (!filename[i].endsWith(".xml") || StringUtils.isEmpty((CharSequence)(fi = filename[i].replace(".xml", ""))) || (tot = Integer.valueOf(version = fi.replace("v", ""))) <= oldTot) continue;
                if (fileList.size() > 0) {
                    fileList.remove(0);
                }
                fileList.add(f.getAbsolutePath());
                oldTot = tot;
            }
        }
        return fileList;
    }

    public static List<String> getP12OldFileList(String path, String ssinRiziv) {
        if (path == null) {
            return Collections.emptyList();
        }
        ArrayList<String> fileList = new ArrayList<String>();
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            LOG.error("The directory " + path + " does not exist");
            return Collections.emptyList();
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        };
        File[] files = dir.listFiles(filter);
        String olddate = null;
        String filenames = null;
        if (files == null) {
            return Collections.emptyList();
        }
        for (int j = 0; j < files.length; ++j) {
            File f = files[j];
            LOG.info("Keystore filename: " + f.getName());
            if (!f.getName().contains(ssinRiziv) || !f.getName().endsWith(".p12")) continue;
            try {
                filenames = f.getName();
                String[] filename = null;
                filename = f.getName().contains(" ") ? filenames.split(" ") : filenames.split("_");
                for (int i = 0; i < filename.length; ++i) {
                    LOG.debug("Keystore filename part " + i + ":" + filename[i]);
                }
                String[] date = filename[filename.length - 1].split("-");
                for (int i = 0; i < date.length; ++i) {
                    LOG.debug("Keystore date part " + i + ":" + date[i]);
                }
                LOG.debug("Keystore date.length: " + date.length);
                LOG.debug("Keystore date last part: " + date[date.length - 1]);
                String lastDt = date[date.length - 1];
                lastDt = lastDt.substring(0, 6);
                LOG.debug("Keystore lastDt: " + lastDt);
                long newDate = Long.parseLong(date[0] + lastDt);
                LOG.debug("Keystore new date:" + newDate);
                if (olddate != null && newDate > Long.parseLong(olddate)) {
                    if (fileList.size() > 0) {
                        fileList.remove(0);
                    }
                    fileList.add(files[j - 1].getCanonicalPath());
                    olddate = String.valueOf(newDate);
                    continue;
                }
                if (olddate == null) {
                    fileList.add(f.getCanonicalPath());
                    olddate = String.valueOf(newDate);
                    continue;
                }
                fileList.add(f.getCanonicalPath());
                continue;
            }
            catch (IOException e) {
                LOG.error("IOException on getP12OldFileList()", (Throwable)e);
            }
        }
        return fileList;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy(input, output);
        return output.toByteArray();
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copyLarge(input, output, new byte[4096]);
    }

    public static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

