/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.utils;

import java.io.File;

public enum CertificateExtension {
    P12(".p12"),
    ACC_P12(".acc-p12"),
    INT_P12(".int-p12");

    private final String name;

    private CertificateExtension(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static CertificateExtension lookupType(File file) {
        for (CertificateExtension extension : CertificateExtension.values()) {
            if (!file.getName().endsWith(extension.getName())) continue;
            return extension;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isSupported(File file) {
        if (file == null) {
            return false;
        }
        try {
            CertificateExtension.lookupType(file);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String removeExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        return fileName.substring(0, fileName.length() - this.name.length());
    }
}

