/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.handlers;

import be.business.connector.core.utils.MessageDumper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingHandler.class);

    public Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext arg0) {
    }

    public boolean handleFault(SOAPMessageContext c) {
        this.handleMessage(c);
        return true;
    }

    public boolean handleMessage(SOAPMessageContext c) {
        SOAPMessage msg = c.getMessage();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)out);
            LOG.debug(out.size() + " bytes - " + out.toString());
            if (MessageDumper.getInstance().isDumpEnabled()) {
                Boolean outboundProperty = (Boolean)c.get((Object)"javax.xml.ws.handler.message.outbound");
                if (outboundProperty.booleanValue()) {
                    MessageDumper.getInstance().dump(out, MessageDumper.getOperationName(c), "OUT");
                } else {
                    MessageDumper.getInstance().dump(out, MessageDumper.getOperationName(c), "IN");
                }
            }
            out.close();
        }
        catch (Throwable t) {
            LOG.warn("SOAPException when logging the message: ", t);
        }
        return true;
    }
}

