/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.core.ehealth.services;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.ehealth.technicalconnector.service.kgss.impl.KgssServiceImpl;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.impl.KeyPairCredential;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionItem;
import be.fgov.ehealth.etee.kgss._1_0.protocol.GetKeyRequestContent;
import be.fgov.ehealth.etee.kgss._1_0.protocol.GetKeyResponseContent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Element;

public class OptimizedKgssServiceImpl {
    public Map<String, KeyResult> retrieveMultipleKeysWithoutCache(Set<String> keyIds, byte[] myEtk, byte[] kgssEtk) throws IntegrationModuleException {
        KgssServiceImpl kgssService = new KgssServiceImpl();
        GetKeyRequestContent getKeyRequestContent = new GetKeyRequestContent();
        getKeyRequestContent.setETK(myEtk);
        SessionItem sessionItem = Session.getInstance().getSession();
        HashMap<String, KeyResult> result = new HashMap<String, KeyResult>();
        try {
            KeyPairCredential encryptionCredential = new KeyPairCredential(sessionItem.getEncryptionCredential().getPrivateKey(), sessionItem.getEncryptionCredential().getCertificate());
            KeyPairCredential holderOfKeyCredential = new KeyPairCredential(sessionItem.getHolderOfKeyCredential().getPrivateKey(), sessionItem.getHolderOfKeyCredential().getCertificate());
            Element samlAssertion = sessionItem.getSAMLToken().getAssertion();
            Map encryptionPrivateKeys = sessionItem.getEncryptionPrivateKeys();
            kgssService.bootstrap();
            for (String keyId : keyIds) {
                getKeyRequestContent.setKeyIdentifier(Base64.decodeBase64((String)keyId));
                GetKeyResponseContent keyResponse = kgssService.getKey(getKeyRequestContent, (Credential)holderOfKeyCredential, (Credential)encryptionCredential, samlAssertion, encryptionPrivateKeys, kgssEtk);
                KeyResult keyResult = new KeyResult((SecretKey)new SecretKeySpec(keyResponse.getKey(), "AES"), keyId);
                result.put(keyId, keyResult);
            }
        }
        catch (TechnicalConnectorException e) {
            throw new IntegrationModuleException(e);
        }
        return result;
    }
}

