/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.common.ehealth;

import be.business.connector.common.ehealth.EhealthResponseKey;
import be.business.connector.common.ehealth.EhealthSystemKey;
import be.business.connector.core.technical.connector.utils.Crypto;
import be.business.connector.core.utils.EncryptionUtils;
import be.recipe.api.crypto.Message;

public class EhealthCipher
implements Message.Cipher {
    public Crypto crypto;

    public byte[] encrypt(byte[] decryptedMessage, Message.Cipher.Key key) {
        this.init();
        if (key instanceof EhealthSystemKey) {
            return this.crypto.seal(((EhealthSystemKey)key).token(), decryptedMessage);
        }
        return this.crypto.seal(decryptedMessage, key.secret(), key.id().toString());
    }

    private void init() {
        if (this.crypto == null) {
            this.crypto = new Crypto();
        }
    }

    public byte[] decrypt(byte[] encryptedMessage, Message.Cipher.Key key) {
        this.init();
        if (key instanceof EhealthResponseKey) {
            return EncryptionUtils.unsealWithSymmKey(key.secret(), encryptedMessage);
        }
        return this.crypto.unseal(key.secret(), encryptedMessage);
    }
}

