/*
 * Decompiled with CFR 0.152.
 */
package be.business.connector.common;

import be.business.connector.common.ApplicationConfig;
import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.core.utils.I18nHelper;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.core.utils.STSHelper;
import be.business.connector.core.utils.SessionValidator;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionItem;
import org.apache.commons.lang3.StringUtils;

public class StandaloneRequestorProvider {
    private StandaloneRequestorProvider() {
    }

    public static String getRequestorTypeInformation() throws IntegrationModuleException {
        ApplicationConfig.getInstance().assertInitialized();
        return StandaloneRequestorProvider.getRequestorTypeInformation(Session.getInstance().getSession(), PropertyHandler.getInstance());
    }

    public static String getRequestorIdInformation() throws IntegrationModuleException {
        ApplicationConfig.getInstance().assertInitialized();
        return StandaloneRequestorProvider.getRequestorIdInformation(Session.getInstance().getSession(), PropertyHandler.getInstance());
    }

    private static String getRequestorTypeInformation(SessionItem sessionItem, PropertyHandler propertyHandler) throws IntegrationModuleException {
        SessionValidator.assertValidSession(sessionItem);
        String type = propertyHandler != null && propertyHandler.hasProperty("requesttype") ? propertyHandler.getProperty("requesttype") : STSHelper.getType(sessionItem.getSAMLToken().getAssertion());
        return type;
    }

    private static String getRequestorIdInformation(SessionItem sessionItem, PropertyHandler propertyHandler) throws IntegrationModuleException {
        String nihii = null;
        if (propertyHandler != null && propertyHandler.hasProperty("requestid")) {
            nihii = propertyHandler.getProperty("requestid");
        } else {
            SessionValidator.assertValidSession(sessionItem);
            nihii = STSHelper.getNihii(sessionItem.getSAMLToken().getAssertion());
        }
        if (StringUtils.isBlank((CharSequence)nihii)) {
            throw new IntegrationModuleException(I18nHelper.getLabel("error.validation.saml.nihii.not.found"));
        }
        return nihii;
    }
}

