/*
 * Decompiled with CFR 0.152.
 */
package be.apb.gfddpp.common.utils;

import be.recipe.common.exceptions.RecipeException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;

public class JaxContextCentralizer {
    private static JaxContextCentralizer instance;
    private Map<Class<?>, JAXBContext> contextStore;
    private XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    private JaxContextCentralizer() {
        if (this.contextStore == null) {
            this.contextStore = new HashMap();
        }
    }

    public static JaxContextCentralizer getInstance() {
        if (instance == null) {
            instance = new JaxContextCentralizer();
        }
        return instance;
    }

    public synchronized void addContext(Class<?> clazz) throws RecipeException {
        try {
            this.getContext(clazz);
        }
        catch (RecipeException e) {
            throw new RecipeException(e.getMessage(), e);
        }
    }

    public final JAXBContext getContext(Class<?> clazz) throws RecipeException {
        if (!this.contextStore.containsKey(clazz)) {
            try {
                this.contextStore.put(clazz, JAXBContext.newInstance((Class[])new Class[]{clazz}));
            }
            catch (JAXBException e) {
                String message = this.processJAXBException(e);
                throw new RecipeException(message, e);
            }
        }
        return this.contextStore.get(clazz);
    }

    public Unmarshaller getUnmarshaller(Class<?> clazz) throws RecipeException {
        try {
            return this.getContext(clazz).createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RecipeException(e.getMessage(), e);
        }
    }

    public Marshaller getMarshaller(Class<?> clazz) throws RecipeException {
        try {
            return this.getContext(clazz).createMarshaller();
        }
        catch (JAXBException e) {
            throw new RecipeException(e.getMessage(), e);
        }
    }

    public <X> X toObject(Class<X> clazz, String data) throws RecipeException {
        try {
            return this.toObject(clazz, data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RecipeException(e.getMessage(), e);
        }
    }

    public <X> X toObject(Class<X> clazz, byte[] data) throws RecipeException {
        try {
            Object result;
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            if (clazz.getAnnotation(XmlRootElement.class) != null) {
                result = this.getUnmarshaller(clazz).unmarshal((InputStream)bis);
            } else {
                try {
                    JAXBElement jax = this.getUnmarshaller(clazz).unmarshal(this.xmlInputFactory.createXMLStreamReader(bis, "UTF-8"), clazz);
                    result = jax.getValue();
                }
                catch (XMLStreamException e) {
                    throw new RecipeException(e.getMessage(), e);
                }
            }
            return (X)result;
        }
        catch (JAXBException e) {
            String message = this.processJAXBException(e);
            throw new RecipeException(message, e);
        }
    }

    private String processJAXBException(JAXBException e) {
        if (e.getLinkedException() != null) {
            return e.getLinkedException().getMessage();
        }
        return e.getLocalizedMessage();
    }

    public String toXml(Class<?> clazz, Object obj) throws RecipeException {
        StringWriter sw = new StringWriter();
        Marshaller marshaller = this.getMarshaller(clazz);
        try {
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            if (clazz.getAnnotation(XmlRootElement.class) != null) {
                marshaller.marshal(obj, (Writer)sw);
            } else {
                JAXB.marshal((Object)obj, (Writer)sw);
            }
        }
        catch (JAXBException e) {
            throw new RecipeException(e.getMessage(), e);
        }
        return sw.toString();
    }
}

