package be.recipe.services.patient;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * The Class GetPrescriptionForPatientResultSealed.
 */
@XmlRootElement(namespace = "http:/services.recipe.be/patient")
public class GetPrescriptionForPatientResultSealed {

    /**
     * The rid.
     */
    private String rid;

    /**
     * The creation date.
     */
    private Calendar creationDate;

    /**
     * The patient id.
     */
    private String patientId;

    /**
     * The feedback allowed.
     */
    private boolean feedbackAllowed = true;

    /**
     * The prescription.
     */
    private byte[] prescription;

    /**
     * The prescription type.
     */
    private String prescriptionType;

    /**
     * The encryption key id.
     */
    private String encryptionKeyId;

    /**
     * The timestamping id.
     */
    private String timestampingId;

    /**
     * The prescriber.
     */
    private String prescriberId;

    /**
     * Instantiates a new prescription response for executor.
     */
    public GetPrescriptionForPatientResultSealed() {

    }

    /**
	 * Instantiates a new prescription response for executor.
	 *
	 * @param rid
	 *            the rid
	 * @param creationDate
	 *            the creation date
	 * @param patientId
	 *            the patient id
	 * @param feedbackAllowed
	 *            the feedback allowed
	 * @param feedbackAllowedByPatient
	 *            the feedback allowed by patient
	 * @param prescription
	 *            the prescription
	 * @param encryptionKeyId
	 *            the encryption key id
	 * @param prescriptionType
	 *            the prescription type
	 * @param timestampingId
	 *            the timestamping id
	 * @param prescriberId
	 *            the prescriber id
	 */
	GetPrescriptionForPatientResultSealed(String rid, Date creationDate, String patientId, boolean feedbackAllowed,
            boolean feedbackAllowedByPatient, byte[] prescription, String encryptionKeyId, String prescriptionType,
            String timestampingId, String prescriberId) {

        super();
        this.rid = rid;
        this.creationDate = new GregorianCalendar();
        this.creationDate.setTime(creationDate);
		this.patientId = String.format("%011d", patientId);
        this.feedbackAllowed = feedbackAllowed && feedbackAllowedByPatient;
        this.prescription = prescription;
        this.encryptionKeyId = encryptionKeyId;
        this.prescriptionType = prescriptionType;
        this.timestampingId = timestampingId;
        this.prescriberId = prescriberId;
    }

    /**
     * Gets the prescriber id.
     *
     * @return the prescriber id
     */
    public String getPrescriberId() {

        return prescriberId;
    }

    /**
     * Sets the prescriber id.
     *
     * @param prescriberId the new prescriber id
     */
    public void setPrescriberId(String prescriberId) {

        this.prescriberId = prescriberId;
    }

    /**
     * Gets the creation date.
     *
     * @return the creation date
     */
    public Calendar getCreationDate() {

        return creationDate;
    }

    /**
     * Sets the creation date.
     *
     * @param creationDate the new creation date
     */
    public void setCreationDate(Calendar creationDate) {

        this.creationDate = creationDate;
    }

    /**
     * Gets the prescription type.
     *
     * @return the prescription type
     */
    public String getPrescriptionType() {

        return prescriptionType;
    }

    /**
     * Sets the prescription type.
     *
     * @param prescriptionType the new prescription type
     */
    public void setPrescriptionType(String prescriptionType) {

        this.prescriptionType = prescriptionType;
    }

    /**
     * Sets the feedback allowed.
     *
     * @param feedbackAllowed the new feedback allowed
     */
    public void setFeedbackAllowed(boolean feedbackAllowed) {

        this.feedbackAllowed = feedbackAllowed;
    }

    /**
     * Checks if is feedback allowed.
     *
     * @return true, if is feedback allowed
     */
    public boolean isFeedbackAllowed() {

        return feedbackAllowed;
    }

    /**
     * Sets the feedback requested.
     *
     * @param feedbackAllowed the new feedback requested
     */
    @Deprecated
    public void setFeedbackRequested(boolean feedbackAllowed) {

        this.feedbackAllowed = feedbackAllowed;
    }

    /**
     * Gets the rid.
     *
     * @return the rid
     */
    public String getRid() {

        return rid;
    }

    /**
     * Sets the rid.
     *
     * @param rid the new rid
     */
    public void setRid(String rid) {

        this.rid = rid;
    }

    /**
     * Gets the patient id.
     *
     * @return the patient id
     */
    public String getPatientId() {

        return patientId;
    }

    /**
     * Sets the patient id.
     *
     * @param patientId the new patient id
     */
    public void setPatientId(String patientId) {

        this.patientId = patientId;
    }

    /**
     * Gets the prescription.
     *
     * @return the prescription
     */
    public byte[] getPrescription() {

        return prescription;
    }

    /**
     * Sets the prescription.
     *
     * @param prescription the new prescription
     */
    public void setPrescription(byte[] prescription) {

        this.prescription = prescription;
    }

    /**
     * Gets the encryption key id.
     *
     * @return the encryption key id
     */
    public String getEncryptionKeyId() {

        return encryptionKeyId;
    }

    /**
     * Sets the encryption key id.
     *
     * @param encryptionKeyId the new encryption key id
     */
    public void setEncryptionKeyId(String encryptionKeyId) {

        this.encryptionKeyId = encryptionKeyId;
    }

    /**
     * Gets the timestamping id.
     *
     * @return the timestamping id
     */
    public String getTimestampingId() {

        return timestampingId;
    }

    /**
     * Sets the timestamping id.
     *
     * @param timestampingId the new timestamping id
     */
    public void setTimestampingId(String timestampingId) {

        this.timestampingId = timestampingId;
    }
}
