package be.recipe.common.exceptions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import be.recipe.services.core.RecipeError;

/**
 * The Class RecipeExceptionDetails.
 */
@XmlRootElement
@XmlType(name = "RecipeExceptionDetails")
public class RecipeExceptionDetails implements Serializable {

	 private final static long serialVersionUID = 1L;
	    protected String code;
	    @XmlElement(required = true)
	    protected RecipeExceptionDetails.ErrorMap errorMap;

	    /**
	     * Gets the value of the code property.
	     * 
	     * @return
	     *     possible object is
	     *     {@link String }
	     *     
	     */
	    public String getCode() {
	        return code;
	    }

	    /**
	     * Sets the value of the code property.
	     * 
	     * @param value
	     *     allowed object is
	     *     {@link String }
	     *     
	     */
	    public void setCode(String value) {
	        this.code = value;
	    }

	    /**
	     * Gets the value of the errorMap property.
	     * 
	     * @return
	     *     possible object is
	     *     {@link RecipeExceptionDetails.ErrorMap }
	     *     
	     */
	    public RecipeExceptionDetails.ErrorMap getErrorMap() {
	        return errorMap;
	    }

	    /**
	     * Sets the value of the errorMap property.
	     * 
	     * @param value
	     *     allowed object is
	     *     {@link RecipeExceptionDetails.ErrorMap }
	     *     
	     */
	    public void setErrorMap(RecipeExceptionDetails.ErrorMap value) {
	        this.errorMap = value;
	    }


	    /**
	     * <p>Java class for anonymous complex type.
	     * 
	     * <p>The following schema fragment specifies the expected content contained within this class.
	     * 
	     * <pre>
	     * &lt;complexType&gt;
	     *   &lt;complexContent&gt;
	     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
	     *       &lt;sequence&gt;
	     *         &lt;element name="entry" maxOccurs="unbounded" minOccurs="0"&gt;
	     *           &lt;complexType&gt;
	     *             &lt;complexContent&gt;
	     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
	     *                 &lt;sequence&gt;
	     *                   &lt;element name="key" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
	     *                   &lt;element name="value" type="{http:/services.recipe.be/core}recipeError" minOccurs="0"/&gt;
	     *                 &lt;/sequence&gt;
	     *               &lt;/restriction&gt;
	     *             &lt;/complexContent&gt;
	     *           &lt;/complexType&gt;
	     *         &lt;/element&gt;
	     *       &lt;/sequence&gt;
	     *     &lt;/restriction&gt;
	     *   &lt;/complexContent&gt;
	     * &lt;/complexType&gt;
	     * </pre>
	     * 
	     * 
	     */
	    @XmlAccessorType(XmlAccessType.FIELD)
	    @XmlType(name = "", propOrder = {
	        "entries"
	    })
	    public static class ErrorMap
	        implements Serializable
	    {

	        private final static long serialVersionUID = 1L;
	        @XmlElement(name = "entry")
	        protected List<RecipeExceptionDetails.ErrorMap.Entry> entries;

	        /**
	         * Gets the value of the entries property.
	         * 
	         * <p>
	         * This accessor method returns a reference to the live list,
	         * not a snapshot. Therefore any modification you make to the
	         * returned list will be present inside the JAXB object.
	         * This is why there is not a <CODE>set</CODE> method for the entries property.
	         * 
	         * <p>
	         * For example, to add a new item, do as follows:
	         * <pre>
	         *    getEntries().add(newItem);
	         * </pre>
	         * 
	         * 
	         * <p>
	         * Objects of the following type(s) are allowed in the list
	         * {@link RecipeExceptionDetails.ErrorMap.Entry }
	         * 
	         * 
	         */
	        public List<RecipeExceptionDetails.ErrorMap.Entry> getEntries() {
	            if (entries == null) {
	                entries = new ArrayList<RecipeExceptionDetails.ErrorMap.Entry>();
	            }
	            return this.entries;
	        }


	        /**
	         * <p>Java class for anonymous complex type.
	         * 
	         * <p>The following schema fragment specifies the expected content contained within this class.
	         * 
	         * <pre>
	         * &lt;complexType&gt;
	         *   &lt;complexContent&gt;
	         *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
	         *       &lt;sequence&gt;
	         *         &lt;element name="key" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
	         *         &lt;element name="value" type="{http:/services.recipe.be/core}recipeError" minOccurs="0"/&gt;
	         *       &lt;/sequence&gt;
	         *     &lt;/restriction&gt;
	         *   &lt;/complexContent&gt;
	         * &lt;/complexType&gt;
	         * </pre>
	         * 
	         * 
	         */
	        @XmlAccessorType(XmlAccessType.FIELD)
	        @XmlType(name = "", propOrder = {
	            "key",
	            "value"
	        })
	        public static class Entry
	            implements Serializable
	        {

	            private final static long serialVersionUID = 1L;
	            protected String key;
	            protected RecipeError value;

	            /**
	             * Gets the value of the key property.
	             * 
	             * @return
	             *     possible object is
	             *     {@link String }
	             *     
	             */
	            public String getKey() {
	                return key;
	            }

	            /**
	             * Sets the value of the key property.
	             * 
	             * @param value
	             *     allowed object is
	             *     {@link String }
	             *     
	             */
	            public void setKey(String value) {
	                this.key = value;
	            }

	            /**
	             * Gets the value of the value property.
	             * 
	             * @return
	             *     possible object is
	             *     {@link RecipeError }
	             *     
	             */
	            public RecipeError getValue() {
	                return value;
	            }

	            /**
	             * Sets the value of the value property.
	             * 
	             * @param value
	             *     allowed object is
	             *     {@link RecipeError }
	             *     
	             */
	            public void setValue(RecipeError value) {
	                this.value = value;
	            }

	        }

	    }


}
