package be.recipe.common.exceptions;

import javax.xml.ws.WebFault;

/**
 * The Class RecipeException.
 */
@WebFault(name = "RecipeException", targetNamespace="http://services.recipe.be" )
public class RecipeException extends Exception {
	
	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 1L;
	
	/** The fault info. */
	private RecipeExceptionDetails faultInfo;
	
	/**
	 * Instantiates a new functional exception.
	 * 
	 * @param message the message
	 * @param faultInfo the fault info
	 */
	public RecipeException(final String message, final RecipeExceptionDetails faultInfo) {
		super(message);
		this.faultInfo = faultInfo;
	}
	
	/**
	 * Instantiates a new functional exception.
	 * 
	 * @param message
	 *            the message
	 * @param cause
	 *            the cause
	 */
	public RecipeException(final String message, final Throwable cause) {
		super(message, cause);
	}

	/**
	 * Instantiates a new functional exception.
	 * 
	 * @param message
	 *            the message
	 * @param faultInfo
	 *            the fault info
	 * @param cause
	 *            the cause
	 */
	public RecipeException(final String message, final RecipeExceptionDetails faultInfo, final Throwable cause) {
		super(message, cause);
		this.faultInfo = faultInfo;
	}
	
	
	/** {@inheritDoc} */
	public RecipeExceptionDetails getFaultInfo() {
	    return faultInfo;
	}
}