package be.recipe.common.exceptions;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * The Class RecipeError.
 * Contains a localized message, severity and resolution
 */
@XmlRootElement
public class RecipeError implements Serializable{

	/** The message. */
	private String message = "";
	
	/** The severity. */
	private String severity = "";
	
	/** The resolution. */
	private String resolution = "";
		
	
	/**
	 * Instantiates a new recipe error.
	 */
	public RecipeError() {
		super();
	}

	/**
	 * Instantiates a new recipe error.
	 * 
	 * @param i18nMsg the i18n msg
	 */
	public RecipeError(String i18nMsg) {
		String[] splitted = i18nMsg.split(RecipeExceptionFactory.SEPERATOR);		
		if (splitted[0] != null) {
			this.message = splitted[0].trim();
		}
		if (splitted.length > 1 && splitted[1] != null) {
			this.severity = splitted[1].trim();
		}
		if (splitted.length > 2 && splitted[2] != null) {
			this.resolution = splitted[2].trim();
		}		
	}
	
	/**
	 * Gets the message.
	 * 
	 * @return the message
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * Gets the severity.
	 * 
	 * @return the severity
	 */
	public String getSeverity() {
		return severity;
	}
	
	/**
	 * Gets the resolution.
	 * 
	 * @return the resolution
	 */
	public String getResolution() {
		return resolution;
	}

	/**
	 * Sets the message.
	 * 
	 * @param message the new message
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * Sets the severity.
	 * 
	 * @param severity the new severity
	 */
	public void setSeverity(String severity) {
		this.severity = severity;
	}

	/**
	 * Sets the resolution.
	 * 
	 * @param resolution the new resolution
	 */
	public void setResolution(String resolution) {
		this.resolution = resolution;
	}	
	
}
