package be.business.connector.recipe.utils;

import static be.business.connector.recipe.utils.PrescriptionViewerFormat.executor_id;
import static be.recipe.api.constraints.Violation.Simple.violation;
import static be.recipe.api.executor.Executor.ID.executorId;
import static be.recipe.api.text.LocalisedMessage.message;
import static be.recipe.services.core.PrescriptionAttribute.PRESCRIPTION_DATE;
import static be.recipe.services.core.PrescriptionAttribute.RESERVATION_MODIFICATION_DATE;
import static be.recipe.services.core.SortOrder.ASCENDING;
import static be.recipe.services.core.SortOrder.DESCENDING;
import static java.util.Locale.forLanguageTag;
import static java8.util.stream.StreamSupport.stream;

import be.recipe.api.Prescription;
import be.recipe.api.constraints.ValidationReport;
import be.recipe.api.constraints.Violation;
import be.recipe.api.executor.Executor;
import be.recipe.api.prescriber.VisionOtherPrescribers;
import be.recipe.api.reservation.ContactPreference;
import be.recipe.api.series.SortedBy;
import be.recipe.api.text.LocalisedMessage;
import be.recipe.services.core.*;
import be.recipe.services.executor.BreakTheGlass;
import be.recipe.services.executor.ReasonBreakTheGlass;
import java.math.BigInteger;
import java8.util.Optional;
import java8.util.function.Consumer;
import java8.util.function.Function;
import java8.util.function.Supplier;
import java8.util.stream.Collectors;
import java8.util.stream.RefStreams;
import java8.util.stream.Stream;

public class JAXB {
  public static ValidationReport from(be.recipe.services.core.ValidationReport from, Object root) {
    return ValidationReport.Simple.from(
        stream(from.getViolations())
            .map(toViolation(root))
            .collect(Collectors.<Violation>toList()));
  }

  private static Function<be.recipe.services.core.ValidationReport.Violation, Violation>
      toViolation(final Object root) {
    return new Function<be.recipe.services.core.ValidationReport.Violation, Violation>() {
      @Override
      public Violation apply(be.recipe.services.core.ValidationReport.Violation it) {
        return from(it, root);
      }
    };
  }

  private static Violation from(
      be.recipe.services.core.ValidationReport.Violation it, Object root) {
    Violation.Simple.Builder builder =
        violation(it.getName())
            .value(it.getPropertyPath().equals("") ? root : parse(it.getValue()))
            .on(it.getPropertyPath())
            .of(it.getUsecase());
    if (it.getTranslations() != null)
      stream(it.getTranslations().getMessages())
          .map(toLocalisedMessage())
          .forEach(installTranslation(builder));
    return builder.build();
  }

  private static Consumer<LocalisedMessage> installTranslation(
      final Violation.Simple.Builder builder) {
    return new Consumer<LocalisedMessage>() {
      @Override
      public void accept(LocalisedMessage localisedMessage) {
        builder.translation(localisedMessage);
      }
    };
  }

  private static Function<LocalisedString, LocalisedMessage> toLocalisedMessage() {
    return new Function<LocalisedString, LocalisedMessage>() {
      @Override
      public LocalisedMessage apply(LocalisedString msg) {
        return message(forLanguageTag(msg.getLang().value()), msg.getValue());
      }
    };
  }

  private static Object parse(String it) {
    if (it.matches(executor_id.pattern())) return PrescriptionViewerFormat.parse(it);
    return it;
  }

  public static Page to(be.recipe.api.series.Page from) {
    Page to = PageFactory.defaultPage();
    to.setPageNumber(BigInteger.valueOf(from.number - 1));
    return to;
  }

  public static SortOrder toJAXB(SortedBy.Order from) {
    switch (from) {
      case ascending:
        return ASCENDING;
      case descending:
        return DESCENDING;
      default:
        throw new IllegalArgumentException("Unknown order! [" + from + "]");
    }
  }

  public static PrescriptionSortedBy toJAXB(SortedBy<Prescription.Attribute>[] from) {
    final PrescriptionSortedBy to = new PrescriptionSortedBy();
    Optional.ofNullable(from)
        .map(
            new Function<
                SortedBy<Prescription.Attribute>[], Stream<SortedBy<Prescription.Attribute>>>() {
              @Override
              public Stream<SortedBy<Prescription.Attribute>> apply(
                  SortedBy<Prescription.Attribute>[] it) {
                return RefStreams.of(it);
              }
            })
        .orElseGet(
            new Supplier<Stream<SortedBy<Prescription.Attribute>>>() {
              @Override
              public Stream<SortedBy<Prescription.Attribute>> get() {
                return RefStreams.empty();
              }
            })
        .map(
            new Function<SortedBy<Prescription.Attribute>, PrescriptionSortedBy.SortedBy>() {
              @Override
              public PrescriptionSortedBy.SortedBy apply(SortedBy<Prescription.Attribute> it) {
                return JAXB.toJAXB(it);
              }
            })
        .forEach(
            new Consumer<PrescriptionSortedBy.SortedBy>() {
              @Override
              public void accept(PrescriptionSortedBy.SortedBy it) {
                to.getSortedBies().add(it);
              }
            });
    return Optional.ofNullable(from)
        .map(
            new Function<SortedBy<Prescription.Attribute>[], PrescriptionSortedBy>() {
              @Override
              public PrescriptionSortedBy apply(SortedBy<Prescription.Attribute>[] it) {
                return to;
              }
            })
        .orElse(null);
  }

  private static PrescriptionSortedBy.SortedBy toJAXB(SortedBy<Prescription.Attribute> from) {
    PrescriptionSortedBy.SortedBy to = new PrescriptionSortedBy.SortedBy();
    to.setAttribute(toJAXB(from.attribute));
    to.setOrder(toJAXB(from.order));
    return to;
  }

  private static PrescriptionAttribute toJAXB(Prescription.Attribute from) {
    switch (from) {
      case prescriptionDate:
        return PRESCRIPTION_DATE;
      case reservationModificationDate:
        return RESERVATION_MODIFICATION_DATE;
      default:
        throw new IllegalArgumentException("Unknown attribute! [" + from + "]");
    }
  }

  public static VisionOtherPrescribers from(be.recipe.services.core.VisionOtherPrescribers from) {
    return Optional.ofNullable(from)
        .map(
            new Function<be.recipe.services.core.VisionOtherPrescribers, VisionOtherPrescribers>() {
              @Override
              public VisionOtherPrescribers apply(
                  be.recipe.services.core.VisionOtherPrescribers it) {
                return VisionOtherPrescribers.valueOf(it.name());
              }
            })
        .orElse(null);
  }

  public static Prescription.Status from(PrescriptionStatus from) {
    return Prescription.Status.valueOf(from.name());
  }

  public static Executor executor(String nihii) {
    return new Executor.Simple(executorId(nihii));
  }

  public static BreakTheGlass toJAXB(be.recipe.api.executor.BreakTheGlass from) {
    if (from == null) return null;
    BreakTheGlass to = new BreakTheGlass();
    to.setReasonBreakTheGlass(ReasonBreakTheGlass.valueOf(from.reason().name()));
    to.setOtherReasonBreakTheGlass(from.description());
    return to;
  }

  public static ContactPreference from(be.recipe.services.core.ContactPreference from) {
    if (from == null) return null;
    return ContactPreference.valueOf(from.name());
  }
}
