package be.business.connector.recipe.utils;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.business.connector.recipe.executor.ExecutorIntegrationModuleV4;
import be.business.connector.recipe.executor.domain.GetPrescriptionForExecutorResult;

public class GetAndMarkAsDeliveredThread extends Thread {

  private final String rid;
  private final ExecutorIntegrationModuleV4 module;
  private GetPrescriptionForExecutorResult result;

  private IntegrationModuleException error;

  public GetAndMarkAsDeliveredThread(String rid, ExecutorIntegrationModuleV4 module) {
    this.rid = rid;
    this.module = module;
  }

  @Override
  public void run() {
    try {
      result = module.getPrescription(rid);
      module.markAsDelivered(rid);
    } catch (final Exception t) {
      error = new IntegrationModuleException(t);
    }
  }

  public GetPrescriptionForExecutorResult getResult() {
    return result;
  }

  public IntegrationModuleException getError() {
    return error;
  }
}
