package be.business.connector.recipe.prescriber;

import static be.business.connector.recipe.utils.JAXB.executor;
import static be.business.connector.recipe.utils.JAXB.from;
import static be.recipe.api.Prescription.RID.prescriptionID;
import static be.recipe.api.Prescription.not_found;
import static be.recipe.api.ThreadLocals.expirationDate;
import static be.recipe.api.constraints.Violation.Simple.violation;
import static be.recipe.api.patient.Patient.ID.patientID;
import static be.recipe.api.prescriber.Prescriber.ID.prescriberID;
import static be.recipe.services.core.PageFactory.defaultPage;
import static be.recipe.services.core.VisionType.PRESCRIBER;

import be.business.connector.core.services.GenericWebserviceCaller;
import be.business.connector.core.services.GenericWebserviceRequest;
import be.business.connector.core.utils.PropertyHandler;
import be.business.connector.recipe.AbstractRecipeClient;
import be.business.connector.recipe.utils.JAXB;
import be.business.connector.recipe.utils.RejectedWithResponse;
import be.fgov.ehealth.recipe.core.v4.CreatePrescriptionAdministrativeInformationType;
import be.fgov.ehealth.recipe.protocol.v4.*;
import be.fgov.ehealth.recipe.protocol.v4.RevokePrescriptionResponse;
import be.recipe.api.GetPrescriptionStatusResponse;
import be.recipe.api.Prescription;
import be.recipe.api.constraints.Rejected;
import be.recipe.api.constraints.ValidationReport;
import be.recipe.api.constraints.Violation;
import be.recipe.api.crypto.Message;
import be.recipe.api.patient.Patient;
import be.recipe.api.prescriber.*;
import be.recipe.api.prescriber.GetPrescriptionStatus;
import be.recipe.api.prescriber.ListPrescriptions;
import be.recipe.api.prescriber.RevokePrescription;
import be.recipe.api.projections.SearchResult;
import be.recipe.api.series.PartialResult;
import be.recipe.api.series.Window;
import be.recipe.api.time.LocalDateRange;
import be.recipe.api.viewer.AllViewer;
import be.recipe.api.viewer.ExecutorViewer;
import be.recipe.api.viewer.PatientViewer;
import be.recipe.services.core.Between;
import be.recipe.services.core.PrescriberForPrescription;
import be.recipe.services.core.PrescriberForSearchResult;
import be.recipe.services.core.PrescriptionStatus;
import be.recipe.services.prescriber.*;
import java.math.BigInteger;

import be.recipe.services.prescriber.CreatePrescription;
import java8.util.Optional;
import java8.util.function.Consumer;
import java8.util.function.Function;
import java8.util.function.Supplier;
import java8.util.stream.RefStreams;
import java8.util.stream.StreamSupport;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.threeten.bp.LocalDate;

public class RecipePrescriberClient extends AbstractRecipeClient
    implements PrescriptionService.Simplified {
  private static final String addressKey = "endpoint.prescriber.v4";

  private DatatypeFactory factory = DatatypeFactory.newInstance();

  public RecipePrescriberClient() throws DatatypeConfigurationException {
    super(addressKey);
  }

  public RecipePrescriberClient(
      Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry,
      Message.Cipher cipher,
      Supplier<String> traceId)
      throws DatatypeConfigurationException {
    super(addressKey, keyRegistry, cipher, traceId);
  }

  public RecipePrescriberClient(PropertyHandler properties) throws DatatypeConfigurationException {
    super(addressKey, properties);
  }

  public RecipePrescriberClient(
      Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry,
      Message.Cipher cipher,
      PropertyHandler properties)
      throws DatatypeConfigurationException {
    super(addressKey, keyRegistry, cipher, properties);
  }

  @Override
  public ListPrescriptions.PartialResult<ListPrescriptions.Response.Encrypted> list(
      ListPrescriptions filters) {
    return list(toJAXB(filters));
  }

  public ListPrescriptions.PartialResult<ListPrescriptions.Response.Encrypted> list(
      ListPrescriptionsParam params) {
    params.setSymmKey(symmKey.getEncoded());

    ListPrescriptionsRequest payload = new ListPrescriptionsRequest();
    payload.setSecuredListPrescriptionsRequest(content(encrypt(params)));
    payload.setProgramId(programId());
    payload.setIssueInstant(DateTime.now());
    payload.setId(traceId.get());

    GenericWebserviceRequest request = new GenericWebserviceRequest();
    request.setRequest(payload.unwrap());
    request.setRequestType(payload.getClass());
    request.setEndpoint(address);
    request.setServiceName(ListPrescriptions.class.getSimpleName());
    request.setAddLoggingHandler(true);
    request.setAddSoapFaultHandler(true);
    request.setAddInsurabilityHandler(true);
    request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:listPrescriptions\"");
    be.fgov.ehealth.recipe.protocol.v4.ListPrescriptionsResponse response =
        GenericWebserviceCaller.callGenericWebservice(
            request, be.fgov.ehealth.recipe.protocol.v4.ListPrescriptionsResponse.class);
    return fromJAXB(
        decrypt(
            response.getSecuredListPrescriptionsResponse().getSecuredContent(),
            ListPrescriptionsResult.class),
        request);
  }

  private ListPrescriptions.PartialResult<ListPrescriptions.Response.Encrypted> fromJAXB(
      final ListPrescriptionsResult from, Object root) {
    if (rejected(from.getStatus()))
      throw new Rejected(from(from.getStatus().getValidationReport(), root));
    return ListPrescriptions.PartialResult.Simple.wrap(
            PartialResult.Simple.of(
                    new java8.util.function.Supplier<
                        java8.util.stream.Stream<ListPrescriptions.Response.Encrypted>>() {
                      @Override
                      public java8.util.stream.Stream<ListPrescriptions.Response.Encrypted> get() {
                        return StreamSupport.stream(from.getPartial().getPrescriptions())
                            .map(toListPrescriptionsResponseEncrypted());
                      }
                    })
                .hasMore(from.getPartial().isHasMoreResults()))
        .hasHidden(from.getPartial().isHasHidden());
  }

  private static Function<
          ListPrescriptionsResult.Partial.Prescription, ListPrescriptions.Response.Encrypted>
      toListPrescriptionsResponseEncrypted() {
    return new Function<
        ListPrescriptionsResult.Partial.Prescription, ListPrescriptions.Response.Encrypted>() {
      @Override
      public ListPrescriptions.Response.Encrypted apply(
          ListPrescriptionsResult.Partial.Prescription prescription) {
        return RecipePrescriberClient.toResponse(prescription);
      }
    };
  }

  private static ListPrescriptions.Response.Encrypted toResponse(
      ListPrescriptionsResult.Partial.Prescription prescription) {
    ListPrescriptions.Response.Encrypted.Simple response =
        ListPrescriptions.Response.Encrypted.Simple.response(prescriptionID(prescription.getRid()));
    response.creationDate = fromJAXB(prescription.getDate());
    response.expirationDate = fromJAXB(prescription.getValidUntil());
    response.status = Prescription.Status.valueOf(prescription.getStatus().name());
    response.prescriber = toPrescriber(prescription.getPrescriber());
    response.visionOtherPrescribers =
        prescription.getVisionOtherPrescribers() != null
            ? VisionOtherPrescribers.valueOf(prescription.getVisionOtherPrescribers().name())
            : null;
    response.encryptedPrescriptionContent = prescription.getEncryptedContent();
    response.encryptionKey = prescription.getEncryptionKey();
    return response;
  }

  private static org.threeten.bp.LocalDate fromJAXB(XMLGregorianCalendar from) {
    return org.threeten.bp.LocalDate.of(from.getYear(), from.getMonth(), from.getDay());
  }

  private static SearchResult.Prescriber toPrescriber(PrescriberForSearchResult prescriber) {
    return SearchResult.Prescriber.Simple.type(
            Optional.ofNullable(prescriber.getType())
                .map(
                    new Function<String, PrescriberType>() {
                      @Override
                      public PrescriberType apply(String it) {
                        return PrescriberType.valueOf(it);
                      }
                    })
                .orElse(null))
        .id(prescriberID(prescriber.getId()));
  }

  private ListPrescriptionsParam toJAXB(be.recipe.api.prescriber.ListPrescriptions request) {
    ListPrescriptionsParam params = new ListPrescriptionsParam();
    params.setPatientId(request.patient == null ? null : request.patient.toString());
    params.setStatus(toJAXB(request.status));
    params.setBetween(toJAXB(request.between));
    params.setExpiringBetween(toJAXB(request.expiringBetween));
    params.setPrescriberId(toJAXB(request.prescriberId));
    if (request.window.offset > 0) params.setPage(toJAXB(request.window));
    params.setSortOptions(JAXB.toJAXB(request.sortedBy));
    return params;
  }

  private String toJAXB(Prescriber.ID prescriberId) {
    if (prescriberId == null) {
      return null;
    }
    return prescriberId.toString();
  }

  private Between toJAXB(LocalDateRange from) {
    if (from == null) return null;
    Between to = new Between();
    to.setFrom(toJAXB(from.getStart()));
    to.setToInclusive(toJAXB(from.getEndInclusive()));
    return to;
  }

  private XMLGregorianCalendar toJAXB(LocalDate dt) {
    return factory.newXMLGregorianCalendar(dt.toString());
  }

  private ListPrescriptionsParam.Status toJAXB(Prescription.Status[] status) {
    if (status == null) return null;
    ListPrescriptionsParam.Status to = new ListPrescriptionsParam.Status();
    RefStreams.of(status).map(toPrescriptionStatus()).forEach(setStatus(to));
    return to;
  }

  private static Consumer<PrescriptionStatus> setStatus(final ListPrescriptionsParam.Status to) {
    return new Consumer<PrescriptionStatus>() {
      @Override
      public void accept(PrescriptionStatus it) {
        to.getStatuses().add(it);
      }
    };
  }

  private Function<Prescription.Status, PrescriptionStatus> toPrescriptionStatus() {
    return new Function<Prescription.Status, PrescriptionStatus>() {
      @Override
      public PrescriptionStatus apply(Prescription.Status status) {
        return toJAXB(status);
      }
    };
  }

  private PrescriptionStatus toJAXB(Prescription.Status status) {
    return PrescriptionStatus.valueOf(status.name());
  }

  private be.recipe.services.core.Page toJAXB(Window from) {
    be.recipe.services.core.Page to = defaultPage();
    BigInteger offset = BigInteger.valueOf(from.offset);
    BigInteger pageSize = BigInteger.valueOf(from.count);
    to.setPageNumber(offset.divide(pageSize));
    return to;
  }

  @Override
  public Prescription.Encrypted get(GetPrescription request) {
    return get(toJAXB(request));
  }

  private Prescription.Encrypted get(GetPrescriptionForPrescriberParam params) {
    params.setSymmKey(symmKey.getEncoded());

    GetPrescriptionRequest payload = new GetPrescriptionRequest();
    payload.setSecuredGetPrescriptionRequest(content(encrypt(params)));
    payload.setProgramId(programId());
    payload.setIssueInstant(DateTime.now());
    payload.setId(traceId.get());

    GenericWebserviceRequest request = new GenericWebserviceRequest();
    request.setRequest(payload.unwrap());
    request.setRequestType(payload.getClass());
    request.setEndpoint(address);
    request.setServiceName(GetPrescription.class.getSimpleName());
    request.setAddLoggingHandler(true);
    request.setAddSoapFaultHandler(true);
    request.setAddInsurabilityHandler(true);
    request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:getPrescription\"");
    GetPrescriptionResponse response =
        GenericWebserviceCaller.callGenericWebservice(request, GetPrescriptionResponse.class);
    return fromJAXB(
        decrypt(
            response.getSecuredGetPrescriptionResponse().getSecuredContent(),
            GetPrescriptionForPrescriberResult.class),
        params);
  }

  @Override
  public GetPrescriptionStatusResponse get(GetPrescriptionStatus request) {
    return get(toJAXB(request));
  }

  private GetPrescriptionStatusResponse get(GetPrescriptionStatusParam params) {
    params.setSymmKey(symmKey.getEncoded());

    GetPrescriptionStatusRequest payload = new GetPrescriptionStatusRequest();
    payload.setSecuredGetPrescriptionStatusRequest(content(encrypt(params)));
    payload.setProgramId(programId());
    payload.setIssueInstant(DateTime.now());
    payload.setId(traceId.get());

    GenericWebserviceRequest request = new GenericWebserviceRequest();
    request.setRequest(payload.unwrap());
    request.setRequestType(payload.getClass());
    request.setEndpoint(address);
    request.setServiceName(GetPrescriptionStatus.class.getSimpleName());
    request.setAddLoggingHandler(true);
    request.setAddSoapFaultHandler(true);
    request.setAddInsurabilityHandler(true);
    request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:getPrescriptionStatus\"");

    be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusResponse response =
        GenericWebserviceCaller.callGenericWebservice(
            request, be.fgov.ehealth.recipe.protocol.v4.GetPrescriptionStatusResponse.class);
    return fromJAXB(
        decrypt(
            response.getSecuredGetPrescriptionStatusResponse().getSecuredContent(),
            GetPrescriptionStatusResult.class));
  }

  private GetPrescriptionStatusResponse fromJAXB(GetPrescriptionStatusResult from) {
    return GetPrescriptionStatusResponse.Simple.response()
        .status(from(from.getPrescriptionStatus()))
        .executor(executor(from.getExecutorId()));
  }

  private be.recipe.services.prescriber.GetPrescriptionStatusParam toJAXB(
      GetPrescriptionStatus from) {
    be.recipe.services.prescriber.GetPrescriptionStatusParam to =
        new be.recipe.services.prescriber.GetPrescriptionStatusParam();
    to.setRid(from.rid.toString());
    return to;
  }

  private Prescription.Encrypted fromJAXB(
      GetPrescriptionForPrescriberResult from, GetPrescriptionForPrescriberParam root) {
    if (rejected(from.getStatus()))
      throw new Rejected(fromJAXB(from.getStatus().getMessageCode(), root));
    PrescriptionWithGetResult to = new PrescriptionWithGetResult();
    to.result = from;
    to.setRid(prescriptionID(from.getRid()));
    to.setPrescriber(fromJAXB(from.getPrescriber()));
    to.setPatient(new Patient.Simple(patientID(from.getPatientId())));
    to.setCreationDate(toLocalDateTime(from.getCreationDate()));
    to.setEncryptedContent(from.getPrescription());
    to.setEncryptionKey(from.getEncryptionKeyId());
    to.setFeedbackAllowed(from.isFeedbackAllowed());
    to.setStatus(Prescription.Status.valueOf(from.getPrescriptionStatus().name()));
    to.setExpirationDate(toLocalDate(from.getExpirationDate()));
    return to;
  }

  public static class PrescriptionWithGetResult extends Prescription.Encrypted.Simple {
    public GetPrescriptionForPrescriberResult result;
  }

  static ValidationReport fromJAXB(String code, GetPrescriptionForPrescriberParam root) {
    Violation.Simple.Builder violation = violation(code);
    if (code.equals(not_found)) violation.on("prescriptionId").value(root.getRid());
    return ValidationReport.Simple.from(violation);
  }

  private Prescriber fromJAXB(PrescriberForPrescription from) {
    return new Prescriber.Simple(
        prescriberID(from.getId()), PrescriberType.valueOf(from.getType()));
  }

  private GetPrescriptionForPrescriberParam toJAXB(GetPrescription from) {
    GetPrescriptionForPrescriberParam to = new GetPrescriptionForPrescriberParam();
    to.setRid(from.rid.toString());
    return to;
  }

  @Override
  public Prescription.Encrypted add(
      be.recipe.api.prescriber.CreatePrescription<Prescription.Encrypted.Specification> request) {
    return add(toJAXB(request), request);
  }

  private Prescription.Encrypted add(
      CreatePrescriptionParam params,
      be.recipe.api.prescriber.CreatePrescription<Prescription.Encrypted.Specification> from) {
    params.setSymmKey(symmKey.getEncoded());

    CreatePrescriptionRequest payload = new CreatePrescriptionRequest();
    payload.setAdministrativeInformation(translate(params, from.customizations));
    payload.setSecuredCreatePrescriptionRequest(content(encrypt(params)));
    payload.setProgramId(programId());
    payload.setId(traceId.get());
    payload.setIssueInstant(DateTime.now());

    GenericWebserviceRequest request = new GenericWebserviceRequest();
    request.setRequest(payload.unwrap());
    request.setRequestType(payload.getClass());
    request.setEndpoint(address);
    request.setServiceName(CreatePrescription.class.getSimpleName());
    request.setAddLoggingHandler(true);
    request.setAddSoapFaultHandler(true);
    request.setAddInsurabilityHandler(true);
    request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:createPrescription\"");
    be.fgov.ehealth.recipe.protocol.v4.CreatePrescriptionResponse response =
        GenericWebserviceCaller.callGenericWebservice(
            request, be.fgov.ehealth.recipe.protocol.v4.CreatePrescriptionResponse.class);
    return fromJAXB(
        decrypt(
            response.getSecuredCreatePrescriptionResponse().getSecuredContent(),
            CreatePrescriptionResult.class),
        params);
  }

  private CreatePrescriptionAdministrativeInformationType translate(
      CreatePrescriptionParam from, Prescription.Specification customizations) {
    CreatePrescriptionAdministrativeInformationType to =
        new CreatePrescriptionAdministrativeInformationType();
    to.setPrescriptionType(from.getPrescriptionType());
    to.setPrescriptionVersion(properties.getProperty("prescription.version"));
    to.setReferenceSourceVersion(customizations.productCode.toString());
    to.setKeyIdentifier(from.getKeyId().getBytes());
    return to;
  }

  private Prescription.Encrypted fromJAXB(
      CreatePrescriptionResult from, CreatePrescriptionParam params) {
    if (rejected(from.getStatus()))
      throw new RejectedWithResponse(from(from.getStatus().getValidationReport(), from), from);
    Prescription.Encrypted.Simple to = new Prescription.Encrypted.Simple();
    to.rid(prescriptionID(from.getRid()));
    return to;
  }

  private CreatePrescriptionParam toJAXB(
      final be.recipe.api.prescriber.CreatePrescription<Prescription.Encrypted.Specification>
          from) {
    CreatePrescriptionParam to = new CreatePrescriptionParam();
    to.setPatientId(from.customizations.patient.id().toString());
    to.setPrescription(from.customizations.encryptedContent);
    to.setPrescriptionType(from.customizations.type.toString());
    to.setFeedbackRequested(from.customizations.feedbackAllowed);
    to.setKeyId(from.customizations.encryptionKeyId);
    to.setExpirationDate(
        Optional.ofNullable(expirationDate())
            .orElseGet(
                new Supplier<String>() {
                  @Override
                  public String get() {
                    return from.customizations.expirationDate == null
                        ? null
                        : from.customizations.expirationDate.toString();
                  }
                }));
    to.setVision(toJAXB(from.customizations.visibleToExecutor));
    to.setVisionOtherPrescribers(toJAXB(from.customizations.visionOtherPrescribers));
    return to;
  }

  private String toJAXB(be.recipe.api.executor.ExecutorViewer viewer) {
    final ViewerToStringProcessor processor = new ViewerToStringProcessor();
    processor.all = "";
    Optional.ofNullable(viewer)
        .ifPresent(
            new Consumer<be.recipe.api.executor.ExecutorViewer>() {
              @Override
              public void accept(be.recipe.api.executor.ExecutorViewer it) {
                it.visit(processor);
              }
            });
    return processor.toString();
  }

  public static be.recipe.services.core.VisionOtherPrescribers toJAXB(VisionOtherPrescribers it) {
    return Optional.ofNullable(it)
        .map(
            new Function<VisionOtherPrescribers, be.recipe.services.core.VisionOtherPrescribers>() {
              @Override
              public be.recipe.services.core.VisionOtherPrescribers apply(
                  VisionOtherPrescribers from) {
                return be.recipe.services.core.VisionOtherPrescribers.valueOf(from.name());
              }
            })
        .orElse(null);
  }

  @Override
  public void update(PutVisionOtherPrescribers request) {
    update(toJAXB(request), PutVisionOtherPrescribers.class);
  }

  private void update(PutVisionParam params, Class<?> usecaseType) {
    params.setSymmKey(symmKey.getEncoded());

    PutVisionForPrescriberRequest payload = new PutVisionForPrescriberRequest();
    payload.setSecuredPutVisionForPrescriberRequest(content(encrypt(params)));
    payload.setProgramId(programId());
    payload.setIssueInstant(DateTime.now());
    payload.setId(traceId.get());

    GenericWebserviceRequest request = new GenericWebserviceRequest();
    request.setRequest(payload.unwrap());
    request.setRequestType(payload.getClass());
    request.setEndpoint(address);
    request.setServiceName(usecaseType.getSimpleName());
    request.setAddLoggingHandler(true);
    request.setAddSoapFaultHandler(true);
    request.setAddInsurabilityHandler(true);
    request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:putVisionForPrescriber\"");
    PutVisionForPrescriberResponse response =
        GenericWebserviceCaller.callGenericWebservice(
            request, PutVisionForPrescriberResponse.class);
    PutVisionResult result =
        decrypt(
            response.getSecuredPutVisionForPrescriberResponse().getSecuredContent(),
            PutVisionResult.class);
    if (rejected(result.getStatus()))
      throw new Rejected(from(result.getStatus().getValidationReport(), result));
  }

  private PutVisionParam toJAXB(PutVisionOtherPrescribers from) {
    PutVisionParam to = new PutVisionParam();
    to.setType(PRESCRIBER);
    to.setRid(Optional.ofNullable(from.prescription).map(toText()).orElse(null));
    to.setVisionOtherPrescribers(
        Optional.ofNullable(from.vision)
            .map(toName())
            .map(toVisionOtherPrescribers())
            .orElse(null));
    return to;
  }

  private static Function<String, be.recipe.services.core.VisionOtherPrescribers>
      toVisionOtherPrescribers() {
    return new Function<String, be.recipe.services.core.VisionOtherPrescribers>() {
      @Override
      public be.recipe.services.core.VisionOtherPrescribers apply(String it) {
        return be.recipe.services.core.VisionOtherPrescribers.valueOf(it);
      }
    };
  }

  @Override
  public void update(RevokePrescription request) {
    update(toJAXB(request));
  }

  private void update(RevokePrescriptionParam params) {
    params.setSymmKey(symmKey.getEncoded());

    RevokePrescriptionRequest payload = new RevokePrescriptionRequest();
    payload.setSecuredRevokePrescriptionRequest(content(encrypt(params)));
    payload.setProgramId(programId());
    payload.setId(traceId.get());

    GenericWebserviceRequest request = new GenericWebserviceRequest();
    request.setRequest(payload.unwrap());
    request.setRequestType(payload.getClass());
    request.setEndpoint(address);
    request.setServiceName(RevokePrescription.class.getSimpleName());
    request.setAddLoggingHandler(true);
    request.setAddSoapFaultHandler(true);
    request.setAddInsurabilityHandler(true);
    request.setSoapAction("\"urn:be:fgov:ehealth:recipe:protocol:v4:revokePrescription\"");
    RevokePrescriptionResponse response =
        GenericWebserviceCaller.callGenericWebservice(request, RevokePrescriptionResponse.class);
    RevokePrescriptionResult result =
        decrypt(
            response.getSecuredRevokePrescriptionResponse().getSecuredContent(),
            RevokePrescriptionResult.class);
    if (rejected(result.getStatus()))
      throw new RejectedWithResponse(
          from(result.getStatus().getValidationReport(), result), result);
  }

  private RevokePrescriptionParam toJAXB(RevokePrescription from) {
    RevokePrescriptionParam to = new RevokePrescriptionParam();
    to.setRid(from.rid.toString());
    to.setReason("-");
    return to;
  }

  private static class ViewerToStringProcessor
      implements be.recipe.api.executor.ExecutorViewer.Visitor {
    private String visi;
    String all;

    @Override
    public void on(AllViewer it) {
      visi = all;
    }

    @Override
    public void on(PatientViewer it) {
      visi = "locked";
    }

    @Override
    public void on(ExecutorViewer it) {
      throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
      return visi;
    }
  }
}
