package be.business.connector.recipe.patient;

import be.recipe.services.patient.*;

// tag::class[]
public interface PatientIntegrationModuleV4 {
  // end::class[]

  /**
   * Gets the vision.
   *
   * @param request the {@link GetVisionParam}
   * @return the {@link GetVisionResult} @ the integration module exception
   */
  GetVisionResult getData(GetVisionParam request);

  /**
   * Put the vision .
   *
   * @param request the {@link PutVisionParam}
   * @return the {@link PutVisionResult} @ the integration module exception
   */
  PutVisionResult putData(PutVisionParam request);

  /**
   * Put the reservation data.
   *
   * @param data the {@link CreateReservationParam}
   * @return the {@link CreateReservationResult} @ the integration module exception
   */
  // tag::create-reservation[]
  @Deprecated
  CreateReservationResult putData(CreateReservationParam data);
  // end::create-reservation[]

  /**
   * Gets the prescription status.
   *
   * @param data the {@link GetPrescriptionStatusParam}
   * @return the {@link GetPrescriptionStatusResult} @ the integration module exception
   */
  GetPrescriptionStatusResult getData(GetPrescriptionStatusParam data);


  /**
   * Gets the open prescription list.
   *
   * @param request the {@link ListOpenRidsParam}
   * @return the {@link ListOpenRidsResult} @ the integration module exception
   */
  ListOpenRidsResult getData(ListOpenRidsParam request);

  /**
   * @return ListPatientPrescriptionsResult
   */
  ListPatientPrescriptionsResult listOpenPrescriptions(
      ListPatientPrescriptionsParam listPatientPrescriptionsParam);

  ListPatientPrescriptionsResult decryptListPatientPrescriptionsResult(
      final ListPatientPrescriptionsResult listOpenPrescriptionsResult);

  /**
   * @param rid the rid
   * @return GetPrescriptionForPatientResult
   */
  GetPrescriptionForPatientResult getPrescription(String rid);

  /**
   * @param rid the rid
   * @param reason the reason
   */
  void revokePrescription(String rid, String reason);
  // tag::class[]
}
// end::class[]
