package be.business.connector.recipe.executor.dto;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.recipe.services.core.ResponseType;
import be.recipe.services.executor.GetOpenPrescriptionForExecutor;
import java8.util.Objects;
import java8.util.function.Function;
import java8.util.function.Predicate;

import java.util.Map;
import java.util.TreeMap;

import static java8.util.Comparators.comparing;
import static java8.util.stream.StreamSupport.stream;

public class ListOpenPrescriptionsResultWithExceptions extends ResponseType {
  private final Map<GetOpenPrescriptionForExecutor, IntegrationModuleException> prescriptions =
      new TreeMap<>(comparing(toRID()));

  private static Function<GetOpenPrescriptionForExecutor, String> toRID() {
    return new Function<GetOpenPrescriptionForExecutor, String>() {
      @Override
      public String apply(GetOpenPrescriptionForExecutor it) {
        return it.getRid();
      }
    };
  }

  private Boolean hasMoreResults;
  private byte[] session;

  public boolean exceptionOccurred() {
    return stream(prescriptions.values()).anyMatch(nonNull());
  }

  private static Predicate<IntegrationModuleException> nonNull() {
    return new Predicate<IntegrationModuleException>() {
      @Override
      public boolean test(IntegrationModuleException it) {
        return Objects.nonNull(it);
      }
    };
  }

  public void addPrescription(
      GetOpenPrescriptionForExecutor prescription, IntegrationModuleException exception) {
    prescriptions.put(prescription, exception);
  }

  public Boolean isHasMoreResults() {
    return hasMoreResults;
  }

  /**
   * Sets the value of the hasMoreResults property.
   *
   * @param value allowed object is {@link Boolean }
   */
  public void setHasMoreResults(Boolean value) {
    this.hasMoreResults = value;
  }

  /**
   * Gets the value of the session property.
   *
   * @return possible object is byte[]
   */
  public byte[] getSession() {
    return session;
  }

  /**
   * Sets the value of the session property.
   *
   * @param value allowed object is byte[]
   */
  public void setSession(byte[] value) {
    this.session = value;
  }

  public Boolean getHasMoreResults() {
    return this.hasMoreResults;
  }

  public Map<GetOpenPrescriptionForExecutor, IntegrationModuleException> getPrescriptions() {
    return prescriptions;
  }
}
