package be.business.connector.core.ehealth.services;

import be.business.connector.core.exceptions.IntegrationModuleException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.ehealth.technicalconnector.service.kgss.impl.KgssServiceImpl;
import be.ehealth.technicalconnector.service.sts.security.impl.KeyPairCredential;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionItem;
import be.fgov.ehealth.etee.kgss._1_0.protocol.GetKeyRequestContent;
import be.fgov.ehealth.etee.kgss._1_0.protocol.GetKeyResponseContent;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Element;

import javax.crypto.spec.SecretKeySpec;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * This class was written in the context of optimizing the single threaded performance of fetching multiple KGSS keys in the .NET version of the SDK
 */
public class OptimizedKgssServiceImpl {

	public Map<String, KeyResult> retrieveMultipleKeysWithoutCache(Set<String> keyIds, final byte[] myEtk, final byte[] kgssEtk)
			throws IntegrationModuleException {
		final KgssServiceImpl kgssService = new KgssServiceImpl();
		final GetKeyRequestContent getKeyRequestContent = new GetKeyRequestContent();
		getKeyRequestContent.setETK(myEtk);
		final SessionItem sessionItem = Session.getInstance().getSession();
		final Map<String, KeyResult> result = new HashMap<>();
		try {
			// Wrap in KeyPairCredential to improve performance (not doing this causes SAMLHolderOfKeyHandler to be slow when executing the requests
			final KeyPairCredential encryptionCredential = new KeyPairCredential(
					sessionItem.getEncryptionCredential().getPrivateKey(),
					sessionItem.getEncryptionCredential().getCertificate());
			final KeyPairCredential holderOfKeyCredential = new KeyPairCredential(
					sessionItem.getHolderOfKeyCredential().getPrivateKey(),
					sessionItem.getHolderOfKeyCredential().getCertificate());
			final Element samlAssertion = sessionItem.getSAMLToken().getAssertion();
			final Map<String, PrivateKey> encryptionPrivateKeys = sessionItem.getEncryptionPrivateKeys();
			kgssService.bootstrap();

			for (String keyId : keyIds) {
				getKeyRequestContent.setKeyIdentifier(Base64.decodeBase64(keyId));
				final GetKeyResponseContent keyResponse = kgssService.getKey(getKeyRequestContent, holderOfKeyCredential, encryptionCredential,
						samlAssertion, encryptionPrivateKeys, kgssEtk);
				final KeyResult keyResult = new KeyResult(new SecretKeySpec(keyResponse.getKey(), "AES"), keyId);
				result.put(keyId, keyResult);
			}
		} catch (TechnicalConnectorException e) {
			throw new IntegrationModuleException(e);
		}

		return result;
	}
}
