package be.business.connector.master;

import be.business.connector.common.Initializer;
import be.business.connector.core.utils.PropertyHandler;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.log4j.LogManager;
import org.apache.log4j.xml.DOMConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitLogging implements Initializer {
  private final Logger logger = LoggerFactory.getLogger(InitLogging.class);

  @Override
  public void initialize(PropertyHandler props) {
    if (props != null) {
      Path path = Paths.get(props.getProperty("LOG4J", "log4j.xml"));
      if (Files.exists(path)) {
        LogManager.resetConfiguration();
        DOMConfigurator.configure(path.toAbsolutePath().toString());
        props.setLog4jInitialized(true);
        logger.info("Loading log4j config from " + path.toAbsolutePath());
      }
    } else {
      logger.info("****************  LOG4J already initialized!!");
    }
  }
}
