/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingPastCalendar;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class DailyMaxRollingFileAppender
extends FileAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    private String datePattern = "'.'yyyy-MM-dd";
    private int maxBackupIndex = 1;
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    RollingPastCalendar rpc = new RollingPastCalendar();
    int checkPeriod = -1;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

    public DailyMaxRollingFileAppender() {
    }

    public DailyMaxRollingFileAppender(Layout layout, String filename, String datePattern) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.maxBackupIndex = maxBackups;
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public void activateOptions() {
        super.activateOptions();
        LogLog.debug((String)("Max backup file kept: " + this.maxBackupIndex + "."));
        if (this.datePattern != null && this.fileName != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int type = this.computeCheckPeriod();
            this.printPeriodicity(type);
            this.rpc.setType(type);
            File file = new File(this.fileName);
            this.scheduledFilename = this.fileName + this.sdf.format(new Date(file.lastModified()));
        } else {
            LogLog.error((String)("Either File or DatePattern options are not set for appender [" + this.name + "]."));
        }
    }

    void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                LogLog.debug((String)"Appender [[+name+]] to be rolled every minute.");
                break;
            }
            case 1: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled on top of every hour."));
                break;
            }
            case 2: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midday and midnight."));
                break;
            }
            case 3: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midnight."));
                break;
            }
            case 4: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of week."));
                break;
            }
            case 5: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of every month."));
                break;
            }
            default: {
                LogLog.warn((String)"Unknown periodicity for appender [[+name+]].");
            }
        }
    }

    int computeCheckPeriod() {
        RollingPastCalendar rollingPastCalendar = new RollingPastCalendar(gmtTimeZone, Locale.ENGLISH);
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 5; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String r0 = simpleDateFormat.format(epoch);
                rollingPastCalendar.setType(i);
                Date next = new Date(rollingPastCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    void rollOver() throws IOException {
        File file;
        boolean result;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
            return;
        }
        String datedFilename = this.fileName + this.sdf.format(this.now);
        if (this.scheduledFilename.equals(datedFilename)) {
            return;
        }
        this.closeFile();
        File target = new File(this.scheduledFilename);
        if (target.exists()) {
            target.delete();
        }
        if (result = (file = new File(this.fileName)).renameTo(target)) {
            LogLog.debug((String)(this.fileName + " -> " + this.scheduledFilename));
            if (this.maxBackupIndex > 0) {
                String dateBeforeStr = this.dateBefore();
                Date tmpDeleteOlder = null;
                try {
                    tmpDeleteOlder = simpleDateFormat.parse(dateBeforeStr);
                }
                catch (ParseException e) {
                    LogLog.error((String)("parsing DatePattern failed " + dateBeforeStr));
                }
                file = new File(this.fileName + dateBeforeStr);
                File logDir = file.getParentFile();
                File[] logDirAll = logDir.listFiles();
                String fileDateSubstring = null;
                String tmpFileName = null;
                Date tmpFileDate = null;
                for (File logFile : logDirAll) {
                    tmpFileName = logFile.getName();
                    fileDateSubstring = tmpFileName.substring(tmpFileName.lastIndexOf(46));
                    if (!fileDateSubstring.contains(".20")) continue;
                    try {
                        tmpFileDate = simpleDateFormat.parse(fileDateSubstring);
                        if (!tmpFileDate.before(tmpDeleteOlder)) continue;
                        logFile.delete();
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                if (file.exists()) {
                    file.delete();
                }
            }
        } else {
            LogLog.error((String)"Failed to rename [[+fileName+]] to [[+scheduledFilename+]].");
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            this.errorHandler.error("setFile(" + this.fileName + ", false) call failed.");
        }
        this.scheduledFilename = datedFilename;
    }

    private String dateBefore() {
        String dataAnte = "";
        if (this.datePattern != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
            dataAnte = simpleDateFormat.format(new Date(this.rpc.getPastCheckMillis(new Date(), this.maxBackupIndex)));
        }
        return dataAnte;
    }

    protected void subAppend(LoggingEvent event) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rpc.getNextCheckMillis(this.now);
            try {
                this.rollOver();
            }
            catch (IOException ioe) {
                LogLog.error((String)"rollOver() failed.", (Throwable)ioe);
            }
        }
        super.subAppend(event);
    }

    public static void main(String[] args) {
        DailyMaxRollingFileAppender dmrfa = new DailyMaxRollingFileAppender();
        dmrfa.setDatePattern("'.'yyyy-MM-dd-HH-mm");
        dmrfa.setFile("prova");
        dmrfa.activateOptions();
        for (int i = 0; i < 5; ++i) {
            dmrfa.subAppend(null);
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

