USE TSbuffer;

CREATE TABLE journal_staging(
	id numeric(20, 0) NOT NULL PRIMARY KEY,
	content varchar(max) NOT NULL,
	type varchar(50) NOT NULL CONSTRAINT journal_typeJournalEntry  DEFAULT ('kmehr'),
	bagId numeric(20, 0) NULL,
	dateBagged datetime NULL
);

GO

-- Copy automatically entries inserted by third-party software into the JOURNAL table into JOURNAL_STAGING, our table
-- And remove the entry in journal to avoid the table to grow infinitely
CREATE TRIGGER JournalToStagingTrigger
ON JOURNAL
AFTER INSERT
AS
INSERT INTO JOURNAL_STAGING(id, content, type)  (select inserted.id, inserted.bytes, inserted.type from inserted);
DELETE FROM JOURNAL WHERE ID = (select inserted.id from inserted);

GO

-- Simulate a sequence, for generating unique bagId
CREATE TABLE bag(
	id numeric(20, 0) IDENTITY(1,1)  NOT NULL PRIMARY KEY
);

-- Initialize seed of sequence from identity column of bags
-- SELECT IDENT_CURRENT('bufBehealthTSBag');
-- DBCC CHECKIDENT ('bag', RESEED, 807);

USE TSarchive;

CREATE TABLE bag_archive(
	id numeric(20, 0) NOT NULL PRIMARY KEY,
	content varchar(max) NOT NULL,
	dateCreated datetime NOT NULL,
	dateSent datetime NOT NULL,
	response varchar(8000) NOT NULL,
	timestampId bigint NOT NULL,
	timestampDate numeric(22, 0) NOT NULL);

CREATE TABLE journal_archive(
	id numeric(20, 0) NOT NULL PRIMARY KEY,
	bagId numeric(20, 0) NOT NULL,
	content varchar(max) NOT NULL,
	type varchar(50) NOT NULL);

ALTER TABLE journal_archive ADD  CONSTRAINT FK_journalarchive_bagId FOREIGN KEY(bagId)
REFERENCES bag_archive (id);