_How to install and use the timeStamp client v2_

# First phase, before the migration

System setup before the migration:
1. Stop your third party software from inserting entries/prescriptions in the TSBuffer.journal table
2. Stop the timeStamp client v1 Windows Service and other scheduled tasks (checkArchiveDb, ...)
3. All tables in TSBuffer should be empty. If it's not the case, then **TODO** 
4. Make a backup of the whole database TS_ARCHIVE, the configuration files and the installed client executable code

# Second phase, installation and configuration

## eHealth configuration
In order to be able to access eHealth timestamp webservices, you need to have
1. a certificate defined/installed in the specific eHealth environment, you can reuse the ones (one for acceptance and one for production) from the old client
2. a tsa client name that identifies uniquely your client that will be linked to the certificate. Again it can be the same than the v1.

You can request the upper items from eHealth via the email address integration-support@ehealth.fgov.be.

You can have a specific configuration for acceptance testing (specific acceptance certificate but same tsa client name than production) for acceptance if you want to test your client on our acceptance environment (strongly recommended).

## Server environment

* **Java** should be installed. The Java OpenJdk 8 (currently 1.8.0_171-1-ojdkbuild) is the version supported by eHealth, because it's in Oracle Long Term Support. If you really want a lower version, please ensure that TSL 1.2 is supported.

* Official **Windows** version supported is Microsoft Windows 7 Enterprise | Version	6.1.7601 Service Pack 1 Build 7601

* Official **Linux** version supported is Red Hat Enterprise Linux Server release 6.10 (Santiago)

* **SQL server 2008 R2 SP2** is the supported version for the database.

By _official version supported_, we means that we tests the client on theses systems before each new release. Other versions can be used that what we recommend, but we don't warranty that the client will works properly (but will try to help you).

## Client installation

1. Create a new root folder for your client, let's call it **TSA_HOME**
2. Download the latest release from eHealth public repository and copy them to your **TSA_HOME** directory:
    - [The timeStamp client v2 executable](http://repo.ehealth.fgov.be/artifactory/webapp/#/artifacts/browse/tree/General/maven2/be/fgov/ehealth/timestamping/timestamping-client-boot)
    - [The timeStamp client v2 configuration validator](http://repo.ehealth.fgov.be/artifactory/webapp/#/artifacts/browse/tree/General/maven2/be/fgov/ehealth/timestamping/timestamping-client-validator)
    - [A configuration template](http://repo.ehealth.fgov.be/artifactory/webapp/#/artifacts/browse/tree/General/maven2/be/fgov/ehealth/timestamping/timestamping-client-configurationtemplate)
3. Extract the configurationtemplate jar content under the **TSA_HOME** directory
4.	Copy your client certificate (the certificate that idenfities your hospital, obtained in the eHealth configuration upper section) to authenticate your requests for ehealth timestamp webservices security into the config/certificates folder (e.g. in the config-acc/keystores directory for the acceptation environment).
5.	Remove the file named **hospitalSigningCertificate.p12** then rename your client certificate to **hospitalSigningCertificate.p12**.

You should now have something like this:

```
TSA_HOME
    timestamping-client-boot-1.0.0.jar
    timestamping-client-validator-1.0.0.jar
    db
        | client_v2_ddl.sql
    META-INF
        | ...
    config-acc
        | keystores
            | hospitalSigningCertificate.p12
            | acc
                | caCertificateKeystore.jks
                | truststore.jks
                | tsacertificate.jks
                | tslostore.jks
            | prd
                | caCertificateKeystore.jks
                | truststore.jks
                | tsacertificate.jks
                | tslostore.jks
        | application.properties
        | be.ehealth.technicalconnector.properties
        | logback.xml
    config-prd
    ... (same file structure)
```

## Database adaptations

1. Run the script TSA_HOME/db/**ddl_sqlserver_v2.sql** to create the new tables and triggers for the client v2
2. Initialize the seed of the sequence for the journal ids (**TODO** automate this, suggestions welcome)
```
SELECT IDENT_CURRENT('bufBehealthTSBag');
DBCC CHECKIDENT ('bag', RESEED, [the value selected in upper line]);
```
3. Execute the dbcr TSA_HOME/db/**ddl_sqlserver_v2_dbcr_1.sql** that add missing indexes

# Third phase, configuration

Fill-up the following configuration files:
1. In _application.properties_:
    - `java.mail.*`: host and port number of your mail server
    - `mail.*`: subject, destination and sender of a mail that is sent by the application
    - `buffer.datasource.*`: url, username and password for your BUFFER database
    - `archive.datasource.*`: url, username and password for your ARCHIVE database
2. In _be.ehealth.technicalconnector.properties_ of each environment:
    - `timestamping.tsclientid`: your tsa client name
    - `KEYSTORE_DIR`: absolute path to your TSA_HOME/keystores directory
    - `http.*`: host, port, user and password of your HTTP proxy (if you happen to have one)
    - `https.*`: host, port, user and password of your HTTPS proxy (if you happen to have one)
    - `credentials.location`: the relative path to your certificate, starting from your TSA_HOME directory
    - `credentials.password`: the password of your certificate
    - `credentials.alias`: the alias of your certificate
3. In _logback.xml_:
    - choose the log folder, by default it's TSA_HOME/logs/[acc|prd]. 
    - You can also adapt the policy retention, see https://logback.qos.ch/manual/configuration.html for more information

# Fourth phase, configuration validation

For all environments, validate the runtime environment and the configuration.

From the **TSA_HOME** folder, run with a command-line tool the following command:

```
java -Dloader.path=[path_to_you_configuration_folder]\ -jar timestamping-client-validator-1.0.0-beta-1.jar
```

- Don't forget the '\' at the end of the environment specific config folder)
- Don't forget to set the JAVA_HOME var or use java executable full path)

It will display a report of the state of the configuration.

Pay attention that if you want to reduce the logs nuisances, you should adapt or set a `logback.xml` file before running the configuration's validation.

Once the configuration validated, you will have a report that looks like this (with a bit of logs nuisances):

```
16:52:23.388 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:23.389 | Logger:73 | |                                                                                        |
16:52:23.390 | Logger:73 | |                       eHealth TSA Client Configuration Validator                       |
16:52:23.390 | Logger:73 | |                                                                                        |
16:52:23.390 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:23.390 | Logger:73 |
16:52:23.392 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:23.393 | Logger:73 | | Verifying presence of configuration files                                              |
16:52:23.393 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:23.393 | Logger:73 |
16:52:23.394 | Logger:73 |              [OK] [application.properties] exists
16:52:23.394 | Logger:73 |              [OK] [be.ehealth.technicalconnector.properties] exists
16:52:23.395 | Logger:73 |
16:52:23.397 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:23.398 | Logger:73 | | Verifying [application.properties] configuration file                                  |
16:52:23.398 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:23.398 | Logger:73 |
16:52:23.399 | Logger:73 |              [OK] [java.mail.host] set
16:52:23.399 | Logger:73 |              [OK] [java.mail.port] set
16:52:23.400 | Logger:73 |              [OK] [java.mail.transport.protocol] set
16:52:23.400 | Logger:73 |              [OK] [mail.subject] set
16:52:23.400 | Logger:73 |              [OK] [mail.from] set
16:52:23.400 | Logger:73 |              [OK] [mail.to] set
16:52:23.401 | Logger:73 |              [OK] [buffer.datasource.url] set
16:52:23.401 | Logger:73 |              [OK] [buffer.datasource.username] set
16:52:23.402 | Logger:73 |              [OK] [buffer.datasource.password] set
16:52:23.402 | Logger:73 |              [OK] [archive.datasource.url] set
16:52:23.403 | Logger:73 |              [OK] [archive.datasource.username] set
16:52:23.403 | Logger:73 |              [OK] [archive.datasource.password] set
16:52:23.404 | Logger:73 |
16:52:23.404 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:23.404 | Logger:73 | | Verifying [be.ehealth.technicalconnector.properties] configuration file                |
16:52:23.405 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:23.406 | Logger:73 |
16:52:23.407 | Logger:73 |              [OK] [timestamping.tsclientid] set
16:52:23.409 | Logger:73 |              [OK] [endpoint.ts.authority] set
16:52:23.410 | Logger:73 |              [OK] [endpoint.ts.consult] set
16:52:23.412 | Logger:73 |              [OK] [credentials.location] set
16:52:23.413 | Logger:73 |              [OK] [credentials.password] set
16:52:23.414 | Logger:73 |              [OK] [credentials.alias] set
16:52:23.418 | Logger:73 |              [OK] [credentials.type] set
16:52:23.420 | Logger:73 |              [OK] [timestamp.signature.keystore.path] set
16:52:23.422 | Logger:73 |              [OK] [timestamp.signature.keystore.pwd] set
16:52:23.424 | Logger:73 |              [OK] [KEYSTORE_DIR] set and is a directory
16:52:23.425 | Logger:73 |
16:52:23.425 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:23.426 | Logger:73 | | Verifying location of keystores and certificates                                       |
16:52:23.426 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:23.427 | Logger:73 |
16:52:23.733 | Logger:73 |              [OK] /NIHII-HOSPITAL=71089815, TESTINGTSACLIENT 20190207-163953.intrc-p12
16:52:23.746 | Logger:73 |              [OK] /tsacertificate.jks
16:52:23.750 | Logger:73 |              [OK] ${KEYSTORE_DIR}/tslostore.jks
16:52:23.775 | Logger:73 |              [OK] ${KEYSTORE_DIR}/truststore.jks
16:52:23.801 | Logger:73 |              [OK] /caCertificateKeystore.jks
16:52:23.874 | Logger:73 |
16:52:23.877 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:23.878 | Logger:73 | | Verifying V1 database [buffer]                                                         |
16:52:23.879 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:23.883 | Logger:73 |
16:52:24.847 | Logger:73 |              [OK] No problem found with table [journal]
16:52:24.850 | Logger:73 |              [OK] No problem found with table [bufbehealthtsbag]
16:52:24.853 | Logger:73 |              [OK] No problem found with table [bufjournal]
16:52:24.856 | Logger:73 |              [OK] No problem found with table [bufarchive]
16:52:24.857 | Logger:73 |
16:52:24.858 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:24.859 | Logger:73 | | Verifying V1 database [archive]                                                        |
16:52:24.860 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:24.861 | Logger:73 |
16:52:24.951 | Logger:73 |              [OK] No problem found with table [bags]
16:52:24.954 | Logger:73 |              [OK] No problem found with table [journal]
16:52:24.954 | Logger:73 |
16:52:24.960 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:24.963 | Logger:73 | | Verifying V2 database [buffer]                                                         |
16:52:24.963 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:24.965 | Logger:73 |
16:52:24.972 | Logger:73 |              [OK] No problem found with table [journal_staging]
16:52:24.978 | Logger:73 |
16:52:24.995 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:25.004 | Logger:73 | | Verifying V2 database [archive]                                                        |
16:52:25.017 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:25.018 | Logger:73 |
16:52:25.021 | Logger:73 |              [OK] No problem found with table [bag_archive]
16:52:25.027 | Logger:73 |              [OK] No problem found with table [journal_archive]
16:52:25.030 | Logger:73 |
16:52:25.030 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:25.032 | Logger:73 | | Verifying SSL connection to [services-acpt.ehealth.fgov.be] on port [443]              |
16:52:25.034 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:25.035 | Logger:73 |
16:52:25.542 | Logger:73 |              [OK] Successfully connected
16:52:25.543 | Logger:73 |
16:52:25.544 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:25.545 | Logger:73 | | Verifying SSL connection to [services.ehealth.fgov.be] on port [443]                   |
16:52:25.545 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:25.546 | Logger:73 |
16:52:25.581 | Logger:73 |              [OK] Successfully connected
16:52:25.582 | Logger:73 |
16:52:25.582 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:25.584 | Logger:73 | | Verifying eHealth TimeStamp Consultation webservice                                    |
16:52:25.584 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:25.585 | Logger:73 |
16:52:27.792 | Logger:73 |              [OK] Successfully contacted the webservice
16:52:27.794 | Logger:73 |                       -> Error type: none
16:52:27.797 | Logger:73 |                       -> Error number: none
16:52:27.797 | Logger:73 |
16:52:27.798 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:27.798 | Logger:73 | | Verifying eHealth TimeStamp Authority webservice                                       |
16:52:27.799 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:27.801 | Logger:73 |
16:52:29.464 | Logger:73 |              [OK] Successfully contacted the webservice
16:52:29.465 | Logger:73 |                       -> Result major: urn:oasis:names:tc:dss:1.0:resultmajor:Success
16:52:29.466 | Logger:73 |                       -> Result minor: urn:oasis:names:tc:dss:1.0:resultminor:valid:signature:OnAllDocuments
16:52:29.466 | Logger:73 |                       -> Result message: none
16:52:29.467 | Logger:73 |
16:52:29.468 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:29.479 | Logger:73 | | Verifying the mailing system                                                           |
16:52:29.480 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:29.480 | Logger:73 |
16:52:29.740 | Logger:73 |              [OK] An email has been sent. Please, verify your mailbox.
16:52:29.742 | Logger:73 |
16:52:29.744 | Logger:73 | |----------------------------------------------------------------------------------------|
16:52:29.745 | Logger:73 | |                                                                                        |
16:52:29.745 | Logger:73 | |                                        SUCCESS                                         |
16:52:29.745 | Logger:73 | |                                                                                        |
16:52:29.746 | Logger:73 | |----------------------------------------------------------------------------------------|
```
If there are any error, you will see a `FAILED` at the end of the report and a `[FAIL]` in front of each problematic point as well as an explanation why it failed.

If there are missing mandatory properties, there will be a `[FAIL]` next to them, telling those are not set. If there are failures in the properties, the configuration's validation will be `aborted`.

If there are missing non-mandatory properties, there will be a `[WARN]` next to them, telling those are not set. However, this will not be considered as an error and won't stop the configuration's validation.

Run the configuration validator as many time as you need (i.e. after your changes) until you get a `SUCCESS` at the end of the report.

You should have a `SUCCESS` before proceeding with the next phase.

# Fifht phase, manual run in acceptance environment

If you have a `SUCCESS` in the configuration validator's report (see phase four), from the **TSA_HOME** folder, the following command will sign the journals in the database and verify the timestamps of the day:

```
java -Dloader.path=[path_to_you_acceptance_configuration_folder]/ -jar timestamping-client-boot-1.0.0-beta-1.jar --sign --verify
```

The following options are possible:
* `--sign` does sign the entries in the JOURNAL table, by calling the ehealth timestamping authority service.
* `--verify` does check the coherence of the timestamps in the archive database:
  * checks that all bags in the tsarchive.bags table have corresponding journals.
  * checks for today's if all bags have been correctly been timestamped, and are present @ehealth.
  * if options `--start` and `--end` are not specified, default it to today, otherwise, options `--start` and `--end` support the ISO-8601 format (e.g. --start=2011-12-03T10:15:30). Note that the time part is optional.
* `--displayBag` displays a bag details. Repeat it if you want several at once: `--displayBag=1 --displayBag=41`
* `--displayJournal` displays a journal details. Repeat it if you want several at once: `--displayJournal=1 --displayJournal=41`
* `--lock=XXXXX` makes the application lock itself onto the `XXXXX` port number so that only one instance runs at a time.
* `--noLock` disables all lock mechanisms on the application, allowing you to run multiple instances
* `--limitMail` makes the application silent in case of successes (i.e. no mail will be sent) but not in case of errors.

**TODO** what if you don't have an acceptance environment ?

# Sixth phase, schedule the tasks
*Out of scope of the pilot*, but theses instructions can be used to run the program periodically.

This seems the way to go: https://stackoverflow.com/questions/15783553/run-a-jar-file-using-windows-scheduler

eHealth recommandations:

1. The signing should occur at least every five minutes
2. The verification should occur at least once per day
3. You should configure mail and alerts to ensure that the execution are effectively 'executing', and that the execution occurs successfully.
4. You should launch the program only one instance at a time.
   You have 3 possibilities:
   - By default, the application will use a file lock mechanism in order to make sure you have only one instance running. Trying to launch other instances of the application will raise an error and cause the application to stop. Be aware you should make sure the user who launches the application has enough rights so the application can create, read and write files without problems. The lock file (`tsa.lock`) will be located in the temporary directory of your operating system (system propery `java.io.tmpdir` from Java) and, therefore, will be automatically deleted in case of an unexpected crash/reboot. If, for some reason, the lock file is not deleted, the application will detect it and override it if there are no other instances running.
   - Launch the application with the argument `--lock=XXXXX` where `XXXXX` is an available network port number onto which the application can lock itself. If the port number is not specified, empty or invalid, the application will lock itself onto a default port number, which is `65534`. Trying to launch other instances of the application will raise an error. The port will be released once the process is killed (normal ending, unexpected crash, reboot, ...).
     ```
     java -Dloader.path=[path_to_you_acceptance_configuration_folder]/ -jar timestamping-client-boot-1.0.0-beta-1.jar --sign --verify --lock=12345
     ```
   - Launch the application with the argument `--noLock`. This will start the process without any lock mechanism what so ever. Please, use this at your own risks. Also, when using this option, you should make sure the application is started only once.
     ```
     java -Dloader.path=[path_to_you_acceptance_configuration_folder]/ -jar timestamping-client-boot-1.0.0-beta-1.jar --sign --verify --noLock
     ```

# Installation from scratch

**TODO**

# Maintenance
## How to renew the timestamp server certificate
Download and copy in the configuration folder the certificates of the timestamping server from [here in French](https://www.ehealth.fgov.be/ehealthplatform/fr/service-datation-electronique-timestamping#docType3) and [here in Dutch](https://www.ehealth.fgov.be/ehealthplatform/nl/service-elektronische-datering-timestamping#docType3)
   
- They allow the client to verify that the token has been produced by the eHealth timestamping server
- Note that they are all stored into a single keystore, it's easier than having multiple files in a folder

## How to renew the bus certificate
**TODO**

# Troubleshooting

## Known issue (not blocking) with the connector

```
10:07:39.940 [Timer-0] ERROR b.e.t.c.i.ConfigurationModuleTrustStore$TrustStoreTimerTask - Unable to update truststores
java.lang.ClassNotFoundException: be.fgov.ehealth.technicalconnector.bootstrap.tsl.TrustStoreUpdater
        at java.net.URLClassLoader.findClass(URLClassLoader.java:381)
        at java.lang.ClassLoader.loadClass(ClassLoader.java:424)
        at org.springframework.boot.loader.LaunchedURLClassLoader.loadClass(LaunchedURLClassLoader.java:93)
        at java.lang.ClassLoader.loadClass(ClassLoader.java:357)
        at java.lang.Class.forName0(Native Method)
        at java.lang.Class.forName(Class.java:264)
        at be.ehealth.technicalconnector.config.impl.ConfigurationModuleTrustStore$TrustStoreTimerTask.run(ConfigurationModuleTrustStore.java:91)
        at java.util.TimerThread.mainLoop(Timer.java:555)
        at java.util.TimerThread.run(Timer.java:505)
10:07:39.944 [main] ERROR b.f.e.t.b.b.EndpointDistributor - Unable to update endpoints
java.lang.ClassNotFoundException: be.fgov.ehealth.technicalconnector.bootstrap.bcp.EndpointUpdater
```

## Configuration is not found
This happens when the configuration folder is not propertly configured (here application.properties is not found)
```
2019-04-09 11:35:03.244  WARN 9468 --- [           main] s.c.a.AnnotationConfigApplicationContext : Exception encountered during context initialization - cancelling refresh attempt: org.springframework.beans.factory.UnsatisfiedDependencyException: Error creating bean with name 'signerApp': Unsatisfied dependency expressed through field 'viewer'; nested exception is org.springframework.beans.factory.UnsatisfiedDependencyException: Error creating bean with name 'viewer' defined in be.fgov.ehealth.tsa.business.BusinessConfiguration: Unsatisfied dependency expressed through method 'viewer' parameter 0; nested exception is org.springframework.beans.factory.UnsatisfiedDependencyException: Error creating bean with name 'be.fgov.ehealth.tsa.persistence.PersistenceConfiguration': Unsatisfied dependency expressed through field 'dataSourceBuffer'; nested exception is org.springframework.beans.factory.BeanCreationException: Error creating bean with name 'dataSourceBuffer' defined in be.fgov.ehealth.tsa.boot.support.BootConfig: Bean instantiation via factory method failed; nested exception is org.springframework.beans.BeanInstantiationException: Failed to instantiate [com.zaxxer.hikari.HikariDataSource]: Factory method 'dataSourceBuffer' threw exception; nested exception is org.springframework.boot.autoconfigure.jdbc.DataSourceProperties$DataSourceBeanCreationException: Failed to determine a suitable driver class
2019-04-09 11:35:03.262  INFO 9468 --- [           main] ConditionEvaluationReportLoggingListener :

Error starting ApplicationContext. To display the conditions report re-run your application with 'debug' enabled.
2019-04-09 11:35:03.274 ERROR 9468 --- [           main] o.s.b.d.LoggingFailureAnalysisReporter   :

***************************
APPLICATION FAILED TO START
***************************

Description:

Failed to configure a DataSource: 'url' attribute is not specified and no embedded datasource could be configured.

Reason: Failed to determine a suitable driver class


Action:

Consider the following:
        If you want an embedded database (H2, HSQL or Derby), please put it on the classpath.
        If you have database settings to be loaded from a particular profile you may need to activate it (no profiles are currently active).
```
If you happen to run the configuration validator before launching the actual Timestamp client v2, and the configuration files are missing, you should get a report looking like this:
```
16:49:31.377 | Logger:73 | |----------------------------------------------------------------------------------------|
16:49:31.378 | Logger:73 | |                                                                                        |
16:49:31.379 | Logger:73 | |                       eHealth TSA Client Configuration Validator                       |
16:49:31.379 | Logger:73 | |                                                                                        |
16:49:31.380 | Logger:73 | |----------------------------------------------------------------------------------------|
16:49:31.380 | Logger:73 |
16:49:31.381 | Logger:73 | |----------------------------------------------------------------------------------------|
16:49:31.381 | Logger:73 | | Verifying presence of configuration files                                              |
16:49:31.382 | Logger:73 | |----------------------------------------------------------------------------------------|
16:49:31.382 | Logger:73 |
16:49:31.383 | Logger:73 |              [FAIL] [application.properties] is missing
16:49:31.383 | Logger:73 |              [FAIL] [be.ehealth.technicalconnector.properties] is missing
16:49:31.384 | Logger:69 |
16:49:31.384 | Logger:73 |              There are missing / problematic configuration files
16:49:31.385 | Logger:73 |              Please, make sure all configuration files are there and correct before proceeding
16:49:31.385 | Logger:73 |
16:49:31.385 | Logger:73 | |----------------------------------------------------------------------------------------|
16:49:31.409 | Logger:73 | |                                                                                        |
16:49:31.409 | Logger:73 | |                                        ABORTED                                         |
16:49:31.414 | Logger:73 | |                                                                                        |
16:49:31.415 | Logger:73 | |----------------------------------------------------------------------------------------|
```

## Enable remote debugging
Run the client with the following command arguments:
```
java -agentlib:jdwp=transport=dt_socket,address=8787,server=y,suspend=y -Dloader.path=configuration\src\main\resources\SQLServer\ -jar boot\target\timestamping-client-boot-1.0.0-SNAPSHOT.jar --sign
```

## TSL not reachable

This is a warning, this just implies that it cannot update automatically the keystores via the trusted list
```
17-04-2019 | 09:04:50 | DEBUG | CertPathCheckerPKIX:59 | Checking trust in certificate chain [X.509 Certificate [Subject=CN="CBE=0809394427, SERVICELIST", OU=eHealth-platform Belgium, OU=EHEALTH-PLATFORM, OU="CBE=0809394427", OU=SERVICELIST, O=Federal Government, C=BE, SerialNumber=179616920595181643936622874361748592724409825353, NotAfter=Sun Nov 29 16:13:00 CET 2020, Issuer=CN=QuoVadis Trust Anchor Issuing CA G2, O=QuoVadis Limited, C=BM], X.509 Certificate [Subject=CN=QuoVadis Trust Anchor Issuing CA G2, O=QuoVadis Limited, C=BM, SerialNumber=3501303195809108160350262893599538130744273833, NotAfter=Wed Apr 09 18:30:04 CEST 2025, Issuer=CN=QuoVadis Trust Anchor Root CA G2, O=QuoVadis Limited, C=BM], ]
17-04-2019 | 09:04:50 | DEBUG | CertPathCheckerPKIX:123 | Checking trust in cert chain...
17-04-2019 | 09:04:50 | ERROR | CertPathCheckerPKIX:71 | Parameters are incorrect for cert path validation.
java.security.InvalidAlgorithmParameterException: the trustAnchors parameter must be non-empty
```
or
```
17-04-2019 | 10:15:08 | WARN  | CertPathCheckerPKIX:83 | Cert chain NOT trusted
java.security.cert.CertPathValidatorException: Path does not chain with any of the trust anchors
17-04-2019 | 10:15:08 | DEBUG | CertPathCheckerPKIX:89 | Details of CertPartValidatorException: Cause=null, CertPath=null, TrustStore=X.509 Certificate [Subject=CN=Belgium Root CA2, C=BE, SerialNumber=4835703278459898099217594, NotAfter=Tue May 13 00:59:00 CEST 2025, Issuer=CN=Cybertrust Global Root, O="Cybertrust, Inc"], X.509 Certificate [Subject=CN=Belgium Root CA3, C=BE, SerialNumber=4260689877497748905, NotAfter=Fri Jan 28 13:00:00 CET 2028, Issuer=CN=Belgium Root CA3, C=BE], X.509 Certificate [Subject=CN=Belgium Root CA2, C=BE, SerialNumber=3098404661496965511, NotAfter=Wed Dec 15 09:00:00 CET 2021, Issuer=CN=Belgium Root CA2, C=BE], X.509 Certificate [Subject=SERIALNUMBER=201401, CN=Government CA, C=BE, SerialNumber=86929879317940727602288277656836721109, NotAfter=Tue Jun 23 13:00:00 CEST 2020, Issuer=CN=Belgium Root CA3, C=BE], X.509 Certificate [Subject=SERIALNUMBER=201402, CN=Government CA, C=BE, SerialNumber=121340244075785135064294145663236702016, NotAfter=Tue Jun 23 13:00:00 CEST 2020, Issuer=CN=Belgium Root CA4, C=BE], X.509 Certificate [Subject=SERIALNUMBER=2011, CN=Government CA, C=BE, SerialNumber=12771448327769967347558985540687194330, NotAfter=Sun Jul 16 13:00:00 CEST 2017, Issuer=SERIALNUMBER=2011, CN=Government CA, C=BE], X.509 Certificate [Subject=CN=Cybertrust Global Root, O="Cybertrust, Inc", SerialNumber=4835703278459682877484360, NotAfter=Wed Dec 15 09:00:00 CET 2021, Issuer=CN=Cybertrust Global Root, O="Cybertrust, Inc"], X.509 Certificate [Subject=CN=Belgium Root CA4, C=BE, SerialNumber=4835703278459898099219750, NotAfter=Tue May 13 00:59:00 CEST 2025, Issuer=CN=Cybertrust Global Root, O="Cybertrust, Inc"], X.509 Certificate [Subject=CN=QuoVadis Trust Anchor Root CA G2, O=QuoVadis Limited, C=BM, SerialNumber=150536682740977230911888785085965362348453825900, NotAfter=Mon Apr 09 16:58:47 CEST 2040, Issuer=CN=QuoVadis Trust Anchor Root CA G2, O=QuoVadis Limited, C=BM], X.509 Certificate [Subject=CN=QuoVadis Trust Anchor Issuing CA G2, O=QuoVadis Limited, C=BM, SerialNumber=3501303195809108160350262893599538130744273833, NotAfter=Wed Apr 09 18:30:04 CEST 2025, Issuer=CN=QuoVadis Trust Anchor Root CA G2, O=QuoVadis Limited, C=BM], X.509 Certificate [Subject=SERIALNUMBER=201401, CN=Government CA, C=BE, SerialNumber=15451356413692218778889440639973472769, NotAfter=Tue Jun 23 13:00:00 CEST 2020, Issuer=SERIALNUMBER=201401, CN=Government CA, C=BE], X.509 Certificate [Subject=CN=Belgium Root CA3, C=BE, SerialNumber=4835703278459898099218750, NotAfter=Tue May 13 00:59:00 CEST 2025, Issuer=CN=Cybertrust Global Root, O="Cybertrust, Inc"], X.509 Certificate [Subject=CN=Baltimore CyberTrust Root, OU=CyberTrust, O=Baltimore, C=IE, SerialNumber=33554617, NotAfter=Tue May 13 01:59:00 CEST 2025, Issuer=CN=Baltimore CyberTrust Root, OU=CyberTrust, O=Baltimore, C=IE], X.509 Certificate [Subject=SERIALNUMBER=201402, CN=Government CA, C=BE, SerialNumber=127327519305080707298891651504920571334, NotAfter=Tue Jun 23 13:00:00 CEST 2020, Issuer=SERIALNUMBER=201402, CN=Government CA, C=BE], X.509 Certificate [Subject=CN=Belgium Root CA4, C=BE, SerialNumber=5706940941790920504, NotAfter=Fri Jan 28 13:00:00 CET 2028, Issuer=CN=Belgium Root CA4, C=BE],
```

## UDDI

Ignore me for now

```
09:04:48.672 [main] ERROR b.e.t.u.ConnectorIOUtils - Location [c:\temp\uddi-local.properties] could not be retrieved as URL, classpath resource or file.
```