-- Use this script if you need to configure the database from scratch

CREATE DATABASE TSbuffer;
GO

USE TSbuffer;

CREATE TABLE journal_staging(
	id numeric(20, 0)  IDENTITY(1,1) NOT NULL PRIMARY KEY,
	content varchar(max) NOT NULL,
	type varchar(50) NOT NULL CONSTRAINT journal_typeJournalEntry  DEFAULT ('kmehr'),
	bagId numeric(20, 0) NULL,
	dateBagged datetime NULL
);

GO

CREATE DATABASE TSarchive;
GO


USE TSarchive;

CREATE TABLE bag_archive(
	id numeric(20, 0) NOT NULL PRIMARY KEY,
	content varchar(max) NOT NULL,
	dateCreated datetime NOT NULL,
	dateSent datetime NOT NULL,
	response varchar(8000) NOT NULL,
	timestampId bigint NOT NULL,
	timestampDate numeric(22, 0) NOT NULL);

CREATE TABLE journal_archive(
	id numeric(20, 0) NOT NULL PRIMARY KEY,
	bagId numeric(20, 0) NOT NULL,
	content varchar(max) NOT NULL,
	type varchar(50) NOT NULL);

ALTER TABLE journal_archive ADD  CONSTRAINT FK_journalarchive_bagId FOREIGN KEY(bagId)
REFERENCES bag_archive (id);