/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.tsa.boot;

import be.fgov.ehealth.tsa.orchestration.OrchestrationConfiguration;
import be.fgov.ehealth.tsa.orchestration.runner.TimeStampRunner;
import be.fgov.ehealth.tsa.ui.runner.FileSingletonClientRunner;
import be.fgov.ehealth.tsa.ui.runner.SimpleClientRunner;
import be.fgov.ehealth.tsa.ui.runner.SocketSingletonClientRunner;
import be.fgov.ehealth.tsa.ui.runner.support.action.Action;
import be.fgov.ehealth.tsa.ui.runner.support.action.ActionCollection;
import be.fgov.ehealth.tsa.ui.runner.support.action.ActionExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableAutoConfiguration(exclude={DataSourceAutoConfiguration.class})
@Import(value={OrchestrationConfiguration.class})
public class Application
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    private static final String TITLE = "TimeStamping Client v2";
    @Autowired
    private TimeStampRunner timeStampRunner;

    public void run(String ... args) {
        try {
            SimpleClientRunner clientRunner;
            ActionExtractor extractor = new ActionExtractor();
            ActionCollection actions = extractor.extract(args);
            if (actions.has(Action.NO_LOCK)) {
                actions.remove(Action.NO_LOCK);
                clientRunner = new SimpleClientRunner(TITLE);
            } else if (actions.has(Action.LOCK)) {
                String lockPort = (String)actions.getValues(Action.LOCK).get(0);
                clientRunner = new SocketSingletonClientRunner(TITLE, lockPort);
            } else {
                clientRunner = new FileSingletonClientRunner(TITLE);
            }
            clientRunner.start(() -> this.timeStampRunner.run(actions));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(new Class[]{Application.class});
        app.setBannerMode(Banner.Mode.OFF);
        app.run(args);
    }
}

