package be.fgov.ehealth.pseudo.hsm.api.exception;

import lombok.Getter;

import java.text.MessageFormat;

@Getter
public class HsmException extends Exception {

    private final ErrorCode errorCode;

    public HsmException(ErrorCode errorCode, Throwable cause, Object... params) {
        super(MessageFormat.format(errorCode.getDescription(), params), cause);
        this.errorCode = errorCode;
    }

    public HsmException(ErrorCode errorCode, Object... params) {
        super(MessageFormat.format(errorCode.getDescription(), params));
        this.errorCode = errorCode;
    }

    public HsmException(ErrorCode errorCode, Throwable cause) {
        super(MessageFormat.format(errorCode.getDescription(), cause.getMessage()), cause);
        this.errorCode = errorCode;
    }

}
