package be.fgov.ehealth.pseudo.hsm.api.domain;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigInteger;
import java.util.Base64;

@Getter
@Setter
@NoArgsConstructor
public class ECPoint {

    public ECPoint(String curve, BigInteger x, BigInteger y) {
        this.curve = curve;
        this.x = x;
        this.y = y;
    }

    private String curve;
    private BigInteger x;
    private BigInteger y;

    @Override
    public String toString() {
        return "ECPoint{" +
                "curve='" + curve + '\'' +
                ", x=" + Base64.getEncoder().encodeToString(x.toByteArray()) +
                ", y=" + Base64.getEncoder().encodeToString(y.toByteArray()) +
                '}';
    }
}
