package be.fgov.ehealth.pseudo.hsm.api;

import be.fgov.ehealth.pseudo.hsm.api.exception.HsmException;

import java.time.LocalDateTime;
import java.util.List;

public interface AdminService {

    void setCallBacks(Callback[] callBacks) throws HsmException;

    void finalizeSEEConn() throws HsmException;

    String getVersions() throws HsmException;

    interface Callback {
        //marker interface
    }

    interface OCSPromptCallback extends Callback {
        void cardPrompt(String prompt);
    }

    interface PasswordPromptCallback extends Callback {
        char[] enterPassword(String prompt);
    }


    interface MasterSecretOperations {
        List<String[]> generateMasterSecret(String masterSecretName, int k, int n) throws HsmException;

        boolean recoverMasterSecret(String masterSecretName, List<String[]> shares, boolean dryRun) throws HsmException;

    }


    interface OperationalToolOperations {

        void generatePassphrase() throws HsmException;

        void deletePassphrases(LocalDateTime before) throws HsmException;

        List<LocalDateTime> getPassphrases() throws HsmException;
    }

    interface DomainOperations {

        void createDomain(String domainName, String masterSecretName, boolean aware) throws HsmException;

        void deleteDomain(String domainName) throws HsmException;

    }


}
