/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.encrypt;

import be.fgov.ehealth.etee.crypto.cert.CertificateStatus;
import be.fgov.ehealth.etee.crypto.encrypt.SignerInfoAttributesSender;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPChecker;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPData;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPException;
import be.fgov.ehealth.etee.crypto.policies.OCSPPolicy;
import be.fgov.ehealth.etee.crypto.status.CryptoResult;
import be.fgov.ehealth.etee.crypto.utils.CertStringBuilder;
import be.fgov.ehealth.etee.crypto.utils.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CmsSigner {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmsSigner.class);
    private final String signatureAlgorithm;
    private final PrivateKey signingKey;
    private final X509Certificate signingCertificate;
    private final List<X509Certificate> caCertificateChain;
    private final String subjectKeyIdentifier;
    private final SignerInfoAttributesSender signerInfoAttributesSender;
    private final OCSPChecker ocspChecker;

    CmsSigner(PrivateKey signingKey, X509Certificate signingCertificate, List<X509Certificate> caCertificateChain, String signatureAlgorithm, OCSPChecker ocspChecker, SignerInfoAttributesSender signerInfoAttributesWriter) {
        this.signingKey = signingKey;
        this.signingCertificate = signingCertificate;
        this.caCertificateChain = caCertificateChain != null ? Collections.unmodifiableList(caCertificateChain) : new ArrayList<X509Certificate>();
        this.subjectKeyIdentifier = null;
        this.signatureAlgorithm = signatureAlgorithm;
        this.ocspChecker = ocspChecker;
        this.signerInfoAttributesSender = signerInfoAttributesWriter;
    }

    CmsSigner(PrivateKey signingKey, String subjectKeyIdentifier, String signatureAlgorithm, OCSPChecker ocspChecker, SignerInfoAttributesSender signerInfoAttributesWriter) {
        this.signingKey = signingKey;
        this.signingCertificate = null;
        this.caCertificateChain = new ArrayList<X509Certificate>();
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        this.signatureAlgorithm = signatureAlgorithm;
        this.ocspChecker = ocspChecker;
        this.signerInfoAttributesSender = signerInfoAttributesWriter;
    }

    public byte[] signData(byte[] dataToBeSigned) throws OperatorCreationException, OCSPException, CertificateException, CMSException, IOException {
        return this.signData(dataToBeSigned, true);
    }

    public OutputStream openDataToBeSignedStream(OutputStream signedDataStream) throws OperatorCreationException, OCSPException, CertificateException, CMSException, IOException {
        return this.openDataToBeSignedStream(signedDataStream, true);
    }

    public byte[] signData(byte[] dataToBeSigned, boolean includeCertificateInSignature) throws OperatorCreationException, OCSPException, CertificateException, CMSException, IOException {
        includeCertificateInSignature = includeCertificateInSignature && this.signingCertificate != null;
        this.logSignerDetails(includeCertificateInSignature);
        CMSSignedDataGenerator signedDataGen = new CMSSignedDataGenerator();
        this.addSignerInfo(includeCertificateInSignature, (CMSSignedGenerator)signedDataGen);
        return signedDataGen.generate((CMSTypedData)new CMSProcessableByteArray(dataToBeSigned), true).getEncoded();
    }

    public OutputStream openDataToBeSignedStream(OutputStream signedDataStream, boolean includeCertificateInSignature) throws OperatorCreationException, OCSPException, CertificateException, CMSException, IOException {
        includeCertificateInSignature = includeCertificateInSignature && this.signingCertificate != null;
        this.logSignerDetails(includeCertificateInSignature);
        CMSSignedDataStreamGenerator signedDataGen = new CMSSignedDataStreamGenerator();
        this.addSignerInfo(includeCertificateInSignature, (CMSSignedGenerator)signedDataGen);
        return signedDataGen.open(CMSObjectIdentifiers.data, signedDataStream, true);
    }

    private void logSignerDetails(boolean includeCertificateInSignature) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Message Signer: [");
            sb.append("SignatureAlgo=").append(this.signatureAlgorithm);
            if (this.subjectKeyIdentifier != null) {
                sb.append(", SubjectKeyIdentifier=").append(this.subjectKeyIdentifier);
            }
            if (includeCertificateInSignature) {
                sb.append(", embedded SignCert=").append(CertStringBuilder.build(this.signingCertificate));
                sb.append(", CACertChain=").append(CertStringBuilder.build(this.caCertificateChain));
            } else {
                sb.append(", SignCert=").append(CertStringBuilder.build(this.signingCertificate));
            }
            sb.append("]");
            LOGGER.debug(sb.toString());
        } else {
            StringBuilder sb = new StringBuilder("Message Signer: ");
            if (this.signingCertificate != null) {
                sb.append(includeCertificateInSignature ? "(embedded) " : "").append("X.509 Certificate [SerialNumber=").append(this.signingCertificate.getSerialNumber());
            } else if (this.subjectKeyIdentifier != null) {
                sb.append("PublicKey [SubjectKeyIdentifier=").append(this.subjectKeyIdentifier);
            }
            sb.append("]");
            LOGGER.info(sb.toString());
        }
    }

    private void addSignerInfo(boolean includeCertificateInSignature, CMSSignedGenerator signedDataGen) throws CMSException, OperatorCreationException, OCSPException, CertificateException, IOException {
        Hashtable<ASN1ObjectIdentifier, ASN1Encodable> unsignedAttrs = new Hashtable<ASN1ObjectIdentifier, ASN1Encodable>();
        if (this.embedRevocationValues(includeCertificateInSignature)) {
            LOGGER.debug("Add RevocationValues to UnsignedAttributes");
            this.addRevocationValues(unsignedAttrs);
        }
        JcaSignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build());
        signerInfoGeneratorBuilder.setUnsignedAttributeGenerator((CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(new AttributeTable(unsignedAttrs)));
        ContentSigner contentSigner = new JcaContentSignerBuilder(this.signatureAlgorithm).build(this.signingKey);
        if (this.signingCertificate != null) {
            signedDataGen.addSignerInfoGenerator(signerInfoGeneratorBuilder.build(contentSigner, this.signingCertificate));
        } else if (this.subjectKeyIdentifier != null) {
            signedDataGen.addSignerInfoGenerator(signerInfoGeneratorBuilder.build(contentSigner, Base64.decode((String)this.subjectKeyIdentifier)));
        } else {
            throw new IllegalArgumentException("SignerInfo requires a certificate or subjectKeyIdentifier to generate signerId");
        }
        if (includeCertificateInSignature) {
            LOGGER.debug("Add Certificate(s) to SignedData.");
            this.addCertificates(signedDataGen);
        }
    }

    private boolean embedRevocationValues(boolean includeCertificateInSignature) {
        if (this.ocspChecker.getPolicy() == OCSPPolicy.NONE) {
            return false;
        }
        return includeCertificateInSignature;
    }

    private void addRevocationValues(Map<ASN1ObjectIdentifier, ASN1Encodable> unsignedAttrs) throws OCSPException, CertificateException, IOException {
        List<X509Certificate> signingCertChain = this.createSigningCertChain();
        CryptoResult<OCSPData> ocspResult = this.ocspChecker.validate(signingCertChain);
        if (ocspResult.hasErrors()) {
            LOGGER.error("OCSPValidation completed with errors: " + ocspResult);
            throw new OCSPException("No valid OCSPResponse available to embed in the signature.");
        }
        if (ocspResult.hasWarnings()) {
            LOGGER.error("OCSPValidation completed with warnings: " + ocspResult.getWarnings());
        }
        if (!CertificateStatus.VALID.equals((Object)ocspResult.getData().getCertStatus())) {
            throw new CertificateException("Signing Certificate is not valid [Status = " + (Object)((Object)ocspResult.getData().getCertStatus()) + "].");
        }
        this.signerInfoAttributesSender.addRevocationValues(unsignedAttrs, ocspResult.getData());
    }

    private List<X509Certificate> createSigningCertChain() {
        List<X509Certificate> certChain = Iterables.newList(this.signingCertificate);
        certChain.addAll(this.caCertificateChain);
        return certChain;
    }

    private void addCertificates(CMSSignedGenerator signedDataGen) throws CMSException, CertificateEncodingException {
        List<X509Certificate> includedCertificates = Iterables.newList(this.signingCertificate);
        if (!this.caCertificateChain.isEmpty()) {
            for (X509Certificate x509Certificate : this.caCertificateChain) {
                if (x509Certificate.equals(this.signingCertificate)) continue;
                includedCertificates.add(x509Certificate);
            }
        }
        signedDataGen.addCertificates((Store)new JcaCertStore(includedCertificates));
        LOGGER.debug("Certificates added to the SignedData generator: " + CertStringBuilder.build(includedCertificates));
    }
}

