/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.client;

import be.fedict.commons.eid.client.BeIDCard;
import be.fedict.commons.eid.client.CardAndTerminalManager;
import be.fedict.commons.eid.client.event.BeIDCardEventsListener;
import be.fedict.commons.eid.client.event.CardEventsListener;
import be.fedict.commons.eid.client.impl.LocaleManager;
import be.fedict.commons.eid.client.impl.VoidLogger;
import be.fedict.commons.eid.client.spi.Logger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;

public class BeIDCardManager {
    private static final byte[] ATR_PATTERN = new byte[]{59, -104, 0, 64, 0, 0, 0, 0, 1, 1, -83, 19, 16};
    private static final byte[] ATR_MASK = new byte[]{-1, -1, 0, -1, 0, 0, 0, 0, -1, -1, -1, -1, -16};
    private final CardAndTerminalManager cardAndTerminalManager;
    private boolean terminalManagerIsPrivate;
    private final Map<CardTerminal, BeIDCard> terminalsAndCards;
    private final Set<BeIDCardEventsListener> beIdListeners;
    private final Set<CardEventsListener> otherCardListeners;
    private final Logger logger;

    public BeIDCardManager() {
        this(new VoidLogger());
    }

    public BeIDCardManager(Logger logger) {
        this(logger, new CardAndTerminalManager());
        this.terminalManagerIsPrivate = true;
    }

    public BeIDCardManager(CardAndTerminalManager cardAndTerminalManager) {
        this(new VoidLogger(), cardAndTerminalManager);
    }

    public BeIDCardManager(final Logger logger, CardAndTerminalManager cardAndTerminalManager) {
        this.logger = logger;
        this.beIdListeners = new HashSet<BeIDCardEventsListener>();
        this.otherCardListeners = new HashSet<CardEventsListener>();
        this.terminalsAndCards = new HashMap<CardTerminal, BeIDCard>();
        this.cardAndTerminalManager = cardAndTerminalManager;
        if (this.terminalManagerIsPrivate) {
            this.cardAndTerminalManager.setProtocol(CardAndTerminalManager.PROTOCOL.T0);
        }
        this.cardAndTerminalManager.addCardListener(new CardEventsListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cardInserted(CardTerminal cardTerminal, Card card) {
                if (card != null && BeIDCardManager.this.matchesEidAtr(card.getATR())) {
                    logger.info("BeID card inserted");
                    BeIDCard beIDCard = BeIDCardManager.this.createBeIDCard(cardTerminal, card);
                    Map map = BeIDCardManager.this.terminalsAndCards;
                    synchronized (map) {
                        BeIDCardManager.this.terminalsAndCards.put(cardTerminal, beIDCard);
                    }
                    BeIDCardManager.this.notifyEIDCardInserted(cardTerminal, beIDCard);
                } else {
                    HashSet copyOfListeners;
                    logger.info("Other card inserted");
                    Set set = BeIDCardManager.this.otherCardListeners;
                    synchronized (set) {
                        copyOfListeners = new HashSet(BeIDCardManager.this.otherCardListeners);
                    }
                    for (CardEventsListener listener : copyOfListeners) {
                        try {
                            listener.cardInserted(cardTerminal, card);
                        }
                        catch (Throwable thrownInListener) {
                            BeIDCardManager.this.logger.error("Exception thrown in CardEventsListener.cardInserted:" + thrownInListener.getMessage());
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cardRemoved(CardTerminal cardTerminal) {
                BeIDCard beIDCard = (BeIDCard)BeIDCardManager.this.terminalsAndCards.get(cardTerminal);
                if (beIDCard != null) {
                    logger.info("BeID card removed");
                    beIDCard.close();
                    Map map = BeIDCardManager.this.terminalsAndCards;
                    synchronized (map) {
                        BeIDCardManager.this.terminalsAndCards.remove(cardTerminal);
                    }
                    BeIDCardManager.this.notifyEIDCardRemoved(cardTerminal, beIDCard);
                } else {
                    HashSet copyOfListeners;
                    logger.info("Other card removed");
                    Set set = BeIDCardManager.this.otherCardListeners;
                    synchronized (set) {
                        copyOfListeners = new HashSet(BeIDCardManager.this.otherCardListeners);
                    }
                    for (CardEventsListener listener : copyOfListeners) {
                        try {
                            listener.cardRemoved(cardTerminal);
                        }
                        catch (Throwable thrownInListener) {
                            BeIDCardManager.this.logger.error("Exception thrown in CardEventsListener.cardRemoved:" + thrownInListener.getMessage());
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cardEventsInitialized() {
                HashSet copyOfOtherCardEventsListeners;
                logger.info("Card events initialized");
                BeIDCardManager.this.notifyEIDCardEventsInitialized();
                Set set = BeIDCardManager.this.otherCardListeners;
                synchronized (set) {
                    copyOfOtherCardEventsListeners = new HashSet(BeIDCardManager.this.otherCardListeners);
                }
                for (CardEventsListener listener : copyOfOtherCardEventsListeners) {
                    try {
                        listener.cardEventsInitialized();
                    }
                    catch (Throwable thrownInListener) {
                        BeIDCardManager.this.logger.error("Exception thrown in BeIDCardEventsListener.eIDCardInserted:" + thrownInListener.getMessage());
                    }
                }
            }
        });
    }

    public BeIDCardManager start() {
        if (this.terminalManagerIsPrivate) {
            this.cardAndTerminalManager.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeIDCardManager addBeIDCardEventListener(BeIDCardEventsListener listener) {
        Set<BeIDCardEventsListener> set = this.beIdListeners;
        synchronized (set) {
            this.beIdListeners.add(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeIDCardManager removeBeIDCardListener(BeIDCardEventsListener listener) {
        Set<BeIDCardEventsListener> set = this.beIdListeners;
        synchronized (set) {
            this.beIdListeners.remove(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeIDCardManager addOtherCardEventListener(CardEventsListener listener) {
        Set<CardEventsListener> set = this.otherCardListeners;
        synchronized (set) {
            this.otherCardListeners.add(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeIDCardManager removeOtherCardEventListener(CardEventsListener listener) {
        Set<CardEventsListener> set = this.otherCardListeners;
        synchronized (set) {
            this.otherCardListeners.remove(listener);
        }
        return this;
    }

    public BeIDCardManager stop() throws InterruptedException {
        if (this.terminalManagerIsPrivate) {
            this.cardAndTerminalManager.stop();
        }
        return this;
    }

    private boolean matchesEidAtr(ATR atr) {
        byte[] atrBytes = atr.getBytes();
        if (atrBytes.length != ATR_PATTERN.length) {
            return false;
        }
        for (int idx = 0; idx < atrBytes.length; ++idx) {
            int n = idx;
            atrBytes[n] = (byte)(atrBytes[n] & ATR_MASK[idx]);
        }
        return Arrays.equals(atrBytes, ATR_PATTERN);
    }

    public BeIDCardManager setLocale(Locale newLocale) {
        LocaleManager.setLocale(newLocale);
        return this;
    }

    public Locale getLocale() {
        return LocaleManager.getLocale();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCards() {
        Map<CardTerminal, BeIDCard> map = this.terminalsAndCards;
        synchronized (map) {
            for (Map.Entry<CardTerminal, BeIDCard> terminalsAndCard : this.terminalsAndCards.entrySet()) {
                BeIDCard beIDCard = terminalsAndCard.getValue();
                try {
                    beIDCard.beginExclusive();
                    beIDCard.endExclusive();
                }
                catch (CardException e) {
                    this.logger.error("begin exclusive failed: " + e.getMessage() + " - replacing BeIDCard instance");
                    beIDCard.close();
                    CardTerminal cardTerminal = terminalsAndCard.getKey();
                    try {
                        BeIDCard newBeIDCard = this.createBeIDCard(cardTerminal, cardTerminal.connect("T=0"));
                        terminalsAndCard.setValue(newBeIDCard);
                        this.notifyEIDCardInserted(cardTerminal, newBeIDCard);
                    }
                    catch (CardException e1) {
                        this.logger.error("card refresh failed: " + e1.getMessage());
                    }
                }
            }
        }
    }

    private BeIDCard createBeIDCard(CardTerminal cardTerminal, Card card) {
        BeIDCard beIDCard = new BeIDCard(card, this.logger);
        beIDCard.setCardTerminal(cardTerminal);
        beIDCard.setLocale(LocaleManager.getLocale());
        return beIDCard;
    }

    private void notifyEIDCardInserted(final CardTerminal cardTerminal, final BeIDCard beIDCard) {
        this.notifyBeIDCardEventsListener(new BeIDCardEventsListenerCallBack(){

            @Override
            public void call(BeIDCardEventsListener listener) {
                listener.eIDCardInserted(cardTerminal, beIDCard);
            }
        });
    }

    private void notifyEIDCardRemoved(final CardTerminal cardTerminal, final BeIDCard beIDCard) {
        this.notifyBeIDCardEventsListener(new BeIDCardEventsListenerCallBack(){

            @Override
            public void call(BeIDCardEventsListener listener) {
                listener.eIDCardRemoved(cardTerminal, beIDCard);
            }
        });
    }

    private void notifyEIDCardEventsInitialized() {
        this.notifyBeIDCardEventsListener(new BeIDCardEventsListenerCallBack(){

            @Override
            public void call(BeIDCardEventsListener listener) {
                listener.eIDCardEventsInitialized();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBeIDCardEventsListener(BeIDCardEventsListenerCallBack callBack) {
        HashSet<BeIDCardEventsListener> copyOfListeners;
        Set<BeIDCardEventsListener> set = this.beIdListeners;
        synchronized (set) {
            copyOfListeners = new HashSet<BeIDCardEventsListener>(this.beIdListeners);
        }
        for (BeIDCardEventsListener listener : copyOfListeners) {
            try {
                callBack.call(listener);
            }
            catch (Throwable thrownInListener) {
                this.logger.error("Exception thrown in BeIDCardEventsListener.eIDCardInserted:" + thrownInListener.getMessage());
            }
        }
    }

    static interface BeIDCardEventsListenerCallBack {
        public void call(BeIDCardEventsListener var1);
    }
}

