/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.jca.ssl;

import be.fedict.commons.eid.jca.BeIDKeyStoreParameter;
import be.fedict.commons.eid.jca.ssl.BeIDManagerFactoryParameters;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeIDX509KeyManager
extends X509ExtendedKeyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeIDX509KeyManager.class);
    private KeyStore keyStore;

    public BeIDX509KeyManager() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this(null);
    }

    public BeIDX509KeyManager(BeIDManagerFactoryParameters beIDSpec) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        BeIDKeyStoreParameter beIDKeyStoreParameter;
        LOGGER.debug("constructor");
        this.keyStore = KeyStore.getInstance("BeID");
        if (null == beIDSpec) {
            beIDKeyStoreParameter = null;
        } else {
            beIDKeyStoreParameter = new BeIDKeyStoreParameter();
            beIDKeyStoreParameter.setLocale(beIDSpec.getLocale());
            beIDKeyStoreParameter.setParentComponent(beIDSpec.getParentComponent());
            beIDKeyStoreParameter.setAutoRecovery(beIDSpec.getAutoRecovery());
            beIDKeyStoreParameter.setCardReaderStickiness(beIDSpec.getCardReaderStickiness());
        }
        this.keyStore.load(beIDKeyStoreParameter);
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        LOGGER.debug("chooseClientAlias");
        for (String keyType : keyTypes) {
            LOGGER.debug("key type: {}", (Object)keyType);
            if (!"RSA".equals(keyType)) continue;
            return "beid";
        }
        return null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        LOGGER.debug("chooseServerAlias");
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        LOGGER.debug("getCertificateChain: {}", (Object)alias);
        if ("beid".equals(alias)) {
            Certificate[] certificateChain;
            try {
                certificateChain = this.keyStore.getCertificateChain("Authentication");
            }
            catch (KeyStoreException e) {
                LOGGER.error("BeID keystore error: " + e.getMessage(), (Throwable)e);
                return null;
            }
            X509Certificate[] x509CertificateChain = new X509Certificate[certificateChain.length];
            for (int idx = 0; idx < certificateChain.length; ++idx) {
                x509CertificateChain[idx] = (X509Certificate)certificateChain[idx];
            }
            return x509CertificateChain;
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        LOGGER.debug("getClientAliases");
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        LOGGER.debug("getPrivateKey: {}", (Object)alias);
        if ("beid".equals(alias)) {
            PrivateKey privateKey;
            try {
                privateKey = (PrivateKey)this.keyStore.getKey("Authentication", null);
            }
            catch (Exception e) {
                LOGGER.error("getKey error: " + e.getMessage(), (Throwable)e);
                return null;
            }
            return privateKey;
        }
        return null;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        LOGGER.debug("getServerAliases");
        return null;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        LOGGER.debug("chooseEngineClientAlias");
        return super.chooseEngineClientAlias(keyType, issuers, engine);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        LOGGER.debug("chooseEngineServerAlias");
        return super.chooseEngineServerAlias(keyType, issuers, engine);
    }
}

