/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.jca.ssl;

import be.fedict.commons.eid.jca.ssl.BeIDManagerFactoryParameters;
import be.fedict.commons.eid.jca.ssl.BeIDX509KeyManager;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeIDKeyManagerFactory
extends KeyManagerFactorySpi {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeIDKeyManagerFactory.class);
    private BeIDManagerFactoryParameters beIDSpec;

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        BeIDX509KeyManager beidKeyManager;
        LOGGER.debug("engineGetKeyManagers");
        try {
            beidKeyManager = new BeIDX509KeyManager(this.beIDSpec);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        KeyManager[] keyManagers = new KeyManager[]{beidKeyManager};
        return keyManagers;
    }

    @Override
    protected void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        LOGGER.debug("engineInit(spec)");
        if (null == spec) {
            return;
        }
        if (!(spec instanceof BeIDManagerFactoryParameters)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.beIDSpec = (BeIDManagerFactoryParameters)spec;
    }

    @Override
    protected void engineInit(KeyStore keyStore, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        LOGGER.debug("engineInit(KeyStore,password)");
    }
}

